<label class="text-black-1200 font-medium xl:text-base lg:text-[13px] text-base leading-6 tracking-[-0.176px] flex items-center gap-1 mb-4">
    {{ __($section['label']) }} 
    @if($section['required'])
        <span class="text-primary-blue">*</span>
    @endif
</label>

<ul class="flex flex-wrap gap-3 items-center">
    @foreach($section['options'] as $value => $option)
        <li>
            <label class="text-mid-gray rounded-full text-sm font-medium gap-1 px-3.5 leading-5 tracking-[-0.096px] inline-flex items-center justify-center border border-solid border-gray-1200 bg-white shadow-3xl h-10 cursor-pointer has-[:checked]:border-primary-blue has-[:checked]:bg-primary-blue has-[:checked]:text-white">
                <input type="radio" 
                       wire:model="availability" 
                       value="{{ $value }}" 
                       class="hidden"
                       @if($value === 'specific_date') x-on:change="if($event.target.checked) document.getElementById('availability-date').style.display = 'block'; else document.getElementById('availability-date').style.display = 'none';" @endif>
                <span class="flex justify-center items-center">
                    @if($option['icon'] === 'flash-small')
                        <x-icon-flash-small class="w-4 h-4" />
                    @elseif($option['icon'] === 'time-one')
                        <x-icon-time-one />
                    @elseif($option['icon'] === 'calendar-close')
                        <x-icon-calendar-close class="w-4 h-4" />
                    @endif
                </span>
                {{ __($option['label']) }}
            </label>
        </li>
    @endforeach
</ul>

@if(isset($section['conditional_field']))
    <div id="availability-date" class="mt-4" style="display: none;" x-data="{ show: false }" x-show="$wire.availability === 'specific_date'">
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Select Date') }}
        </label>
        <input type="date" 
               wire:model.blur="availability_date" 
               class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
               min="{{ date('Y-m-d', strtotime('+1 day')) }}">
    </div>
@endif

@error('availability')
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror

@error('availability_date')
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror