<label class="text-black-1200 font-medium xl:text-base lg:text-[13px] text-base leading-6 tracking-[-0.176px]">
    {{ __($section['label']) }}
    @if($section['required'])
        <span class="text-primary-blue">*</span>
    @endif
</label>

<div class="mt-4" x-data="{ 
    uploading: false, 
    progress: 0, 
    fileName: '', 
    fileUploaded: false 
}" 
x-on:livewire-upload-start="uploading = true; fileUploaded = false"
x-on:livewire-upload-finish="uploading = false; fileUploaded = true"
x-on:livewire-upload-error="uploading = false"
x-on:livewire-upload-progress="progress = $event.detail.progress">

    <!-- File Upload Area -->
    <div class="cursor-pointer border border-dashed border-gray-1600 rounded-xl h-[206px] relative flex items-center justify-center flex-col"
        x-show="!fileUploaded && !uploading"
        x-on:click="$refs.fileInput.click()"
        x-on:drop.prevent="$refs.fileInput.files = $event.dataTransfer.files; $refs.fileInput.dispatchEvent(new Event('change'))"
        x-on:dragover.prevent
        x-on:dragenter.prevent>
        
        <input type="file"
            x-ref="fileInput"
            wire:model="resume"
            class="hidden"
            accept="{{ $section['accept'] }}"
            x-on:change="fileName = $event.target.files[0]?.name || ''">
        
        <x-icon-upload-icon-v2 />
        <h5 class="mt-5 text-sm font-medium leading-5">
            {{ __('Choose a file or drag & drop it here.') }}
        </h5>
        <p class="mt-1.5 mb-5 text-sm font-normal leading-5 text-mid-gray">
            {{ __($section['description']) }}
        </p>
        <span class="text-mid-gray font-normal text-sm border border-solid border-gray-1200 rounded-full h-8 w-[124px] flex items-center justify-center">
            {{ __('Upload Resume') }}
        </span>
    </div>

    <!-- Upload Progress Card -->
    <div x-show="uploading" class="flex items-center p-4 w-full max-w-md rounded-xl border border-gray-1200">
        <div class="flex gap-3 items-center w-full">
            <div class="flex justify-center items-center w-10">
                <x-icon-file-format-pdf />
            </div>
            <div class="flex-1 w-full">
                <div class="flex justify-between items-center text-sm font-medium">
                    <span x-text="fileName" class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]"></span>
                    <button type="button" 
                        x-on:click="$wire.set('resume', null); fileUploaded = false; uploading = false;" 
                        class="flex justify-center items-center w-6 h-6 cursor-pointer">
                        <x-icon-close-outline />
                    </button>
                </div>
                <div class="mt-1 text-xs text-gray-500">
                    <span class="text-xs font-normal leading-4 text-mid-gray">
                        <span x-text="Math.round(progress) + '%'"></span>
                    </span>
                    •
                    <span class="text-xs font-normal leading-4 text-black-1200">{{ __('Uploading...') }}</span>
                </div>
            </div>
        </div>
        <div class="overflow-hidden mt-4 w-full h-1.5 rounded-full bg-gray-1200">
            <div class="h-full bg-primary-blue transition-all duration-300"
                x-bind:style="`width: ${progress}%`"></div>
        </div>
    </div>

    <!-- Upload Success Card -->
    <div x-show="fileUploaded && !uploading" class="flex items-center p-4 w-full max-w-md rounded-xl border border-gray-1200">
        <div class="flex gap-3 items-center w-full">
            <div class="flex justify-center items-center w-10">
                <x-icon-file-format-pdf />
            </div>
            <div class="flex-1 w-full">
                <div class="flex justify-between items-center text-sm font-medium">
                    <span x-text="fileName" class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]"></span>
                    <button type="button" 
                        x-on:click="$wire.set('resume', null); fileUploaded = false;" 
                        class="flex justify-center items-center w-6 h-6 cursor-pointer">
                        <x-icon-close-outline />
                    </button>
                </div>
                <div class="mt-1 text-xs text-gray-500">
                    <span class="text-xs font-normal leading-4 text-green-600">{{ __('Upload complete') }}</span>
                </div>
            </div>
        </div>
    </div>
</div>

@error('resume')
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror