@if($sectionKey === 'legal_authorization' || $sectionKey === 'visa_sponsorship')
    @if($sectionKey === 'legal_authorization')
        <div class="pb-4 border-b border-solid border-gray-1600">
    @else
        <div class="pt-4">
    @endif
        <label class="text-black-1200 font-medium xl:text-base lg:text-[13px] text-base leading-6 tracking-[-0.176px]">
            {{ __($section['label']) }}
            @if($section['required'])
                <span class="text-primary-blue">*</span>
            @endif
        </label>
        <ul class="flex gap-3 items-center mt-4 w-full">
            @foreach($section['options'] as $value => $label)
                <li>
                    <input type="radio"
                        id="{{ $sectionKey }}_{{ $value }}"
                        wire:model="{{ $sectionKey }}"
                        value="{{ $value }}"
                        class="hidden peer"
                        @if($section['required']) required @endif />
                    <label for="{{ $sectionKey }}_{{ $value }}" 
                        class="flex items-center justify-center h-10 w-[105px] text-mid-gray bg-white border border-gray-1200 rounded-full cursor-pointer peer-checked:border-gray-1400 peer-checked:bg-gray-1400">
                        {{ __($label) }}
                    </label>
                </li>
            @endforeach
        </ul>
        @error($sectionKey)
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>
@else
    <label class="text-black-1200 font-medium xl:text-base lg:text-[13px] text-base leading-6 tracking-[-0.176px] mb-4">
        {{ __($section['label']) }}
        @if($section['required'])
            <span class="text-primary-blue">*</span>
        @endif
    </label>
    <ul class="flex gap-3 items-center mt-4 w-full">
        @foreach($section['options'] as $value => $label)
            <li>
                <input type="radio"
                    id="{{ $sectionKey }}_{{ $value }}"
                    wire:model="{{ $sectionKey }}"
                    value="{{ $value }}"
                    class="hidden peer"
                    @if($section['required']) required @endif />
                <label for="{{ $sectionKey }}_{{ $value }}" 
                    class="flex items-center justify-center h-10 w-[105px] text-mid-gray bg-white border border-gray-1200 rounded-full cursor-pointer peer-checked:border-gray-1400 peer-checked:bg-gray-1400">
                    {{ __($label) }}
                </label>
            </li>
        @endforeach
    </ul>
    @error($sectionKey)
        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
    @enderror
@endif