<label class="text-black-1200 font-medium xl:text-base lg:text-[13px] text-base leading-6 tracking-[-0.176px]">
    {{ __('Please answer these questions') }}
    @if($section['required'])
        <span class="text-primary-blue">*</span>
    @endif
</label>

<div class="mt-4">
    <p class="text-black-1200 font-normal text-lg leading-5 tracking-[-0.24px]">
        {{ __($section['label']) }}
    </p>
    
    <!-- Quill Editor Container -->
    <div class="mt-4">
        <div wire:ignore>
            <div id="editor-{{ $sectionKey }}" 
                 class="quill-editor"
                 data-field="{{ $sectionKey }}"
                 data-placeholder="{{ $section['editor_config']['placeholder'] ?? 'Enter your text here...' }}"
                 style="height: 175px;">
            </div>
        </div>
        
        <!-- Hidden input to store the content with real-time validation -->
        <textarea wire:model.blur="{{ $sectionKey }}" class="hidden" id="hidden-{{ $sectionKey }}"></textarea>
    </div>
</div>

@error($sectionKey)
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror