<h3 class="text-xl font-medium leading-7 text-black-1200 mb-4">{{ __('Create Your Account') }}</h3>

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <!-- First Name -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('First Name') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="text"
            wire:model.blur="firstName"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Enter your first name') }}">
        @error('firstName')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- Last Name -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Last Name') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="text"
            wire:model.blur="lastName"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Enter your last name') }}">
        @error('lastName')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- Email -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Email') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="email"
            wire:model.blur="email"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Enter your email') }}">
        @error('email')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- Phone -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Phone') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="tel"
            wire:model.blur="phone"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Enter your phone number') }}">
        @error('phone')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- Country -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Country') }} <span class="text-primary-blue">*</span>
        </label>
        <select wire:model="country" class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue">
            <option value="">{{ __('Select Country') }}</option>
            @foreach($countryList as $country)
                <option value="{{ $country->id }}">{{ $country->country_name }}</option>
            @endforeach
        </select>
        @error('country')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- City -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('City') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="text"
            wire:model.blur="city"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Enter your city') }}">
        @error('city')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- Password -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Password') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="password"
            wire:model.blur="password"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Enter your password') }}">
        @error('password')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>

    <!-- Confirm Password -->
    <div>
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Confirm Password') }} <span class="text-primary-blue">*</span>
        </label>
        <input type="password"
            wire:model.blur="confirmPassword"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue"
            placeholder="{{ __('Confirm your password') }}">
        @error('confirmPassword')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>
</div>

<!-- Include Photo Option -->
<div class="mt-4">
    <label class="flex items-center">
        <input type="checkbox" wire:model="includePhoto" class="rounded border-gray-1200 text-primary-blue focus:ring-primary-blue">
        <span class="ml-2 text-sm text-gray-700">{{ __('Include profile photo') }}</span>
    </label>
</div>

<!-- Photo Upload (conditional) -->
@if($includePhoto)
    <div class="mt-4">
        <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-2">
            {{ __('Profile Photo') }}
        </label>
        <input type="file"
            wire:model="photo"
            accept="image/jpeg,image/png,image/jpg"
            class="w-full px-4 py-2 border border-gray-1200 rounded-lg focus:ring-0 focus:border-primary-blue">
        @error('photo')
            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
        @enderror
    </div>
@endif

<!-- Email Updates Option -->
<div class="mt-4">
    <label class="flex items-center">
        <input type="checkbox" wire:model="emailUpdates" class="rounded border-gray-1200 text-primary-blue focus:ring-primary-blue">
        <span class="ml-2 text-sm text-gray-700">{{ __('I would like to receive email updates about job opportunities') }}</span>
    </label>
</div>