<h4 class="text-black-1200 font-medium xl:text-base lg:text-[13px] text-base leading-6 tracking-[-0.176px] mb-1.5">
    {{ __($section['label']) }}
</h4>
<p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">
    {{ __($section['description']) }}
</p>

<div class="mt-3 mb-5" x-data="{ selectedPlatform: @entangle('video_platform') }">
    <ul class="grid grid-cols-2 gap-1 p-1 rounded-full border border-solid bg-gray-1400 border-gray-1200"
        role="tablist">
        @foreach($section['platforms'] as $platform => $platformConfig)
            <li role="presentation">
                <button 
                    type="button"
                    x-on:click="selectedPlatform = '{{ $platform }}'"
                    x-bind:class="selectedPlatform === '{{ $platform }}' ? 'bg-white text-black-1200 shadow-6xl' : 'text-gray-1500 hover:text-black-1200 hover:bg-white hover:shadow-6xl'"
                    class="inline-flex rounded-full h-8 items-center justify-center cursor-pointer w-full text-sm font-medium leading-5 tracking-[-0.096px] transition-all duration-500 ease-in-out">
                    {{ __($platformConfig['label']) }}
                </button>
            </li>
        @endforeach
    </ul>
</div>

<div x-data="{ selectedPlatform: @entangle('video_platform') }">
    @foreach($section['platforms'] as $platform => $platformConfig)
        @if(isset($platformConfig['url_field']))
            <div x-show="selectedPlatform === '{{ $platform }}'" x-transition>
                <label class="text-black-1200 font-medium text-sm leading-6 tracking-[-0.096px] flex items-center mb-1">
                    {{ __('Link to your ' . ucfirst($platform) . ' video') }}
                </label>
                <div class="relative mb-4">
                    <span class="absolute left-0 top-0 text-gray-1500 font-normal text-sm leading-5 tracking-[-0.096px] flex items-center justify-center border-r border-solid border-gray-1200 h-10 w-[72px]">
                        {{ $platformConfig['url_field']['prefix'] }}
                    </span>
                    <input type="text"
                        wire:model.blur="{{ $platform }}_url"
                        class="text-black-1200 pl-[84px] placeholder:text-gray-1500 font-normal text-sm leading-5 tracking-[-0.096px] border border-solid border-gray-1200 bg-white h-10 rounded-[999px] shadow-3xl w-full focus:ring-0 focus:border-gray-1200"
                        placeholder="{{ $platformConfig['url_field']['placeholder'] }}" />
                </div>
                <a href="#" class="font-medium text-sm leading-5 tracking-[-0.096px] text-primary-blue h-7 px-2.5 inline-flex items-center justify-center">
                    {{ __($platformConfig['url_field']['help_text']) }}
                </a>
            </div>
        @endif
    @endforeach
</div>

@error('video_platform')
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror

@error('youtube_url')
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror

@error('loom_url')
    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
@enderror