<div class="flex flex-col xl:flex-row" x-data="initMemberCitySearch()">
    <div x-data="{
        openCategory: @entangle('openCategory').defer,
        openSubcategory: @entangle('openSubcategory').defer,
        openSpecificServices: @entangle('openSpecificServices').defer,
    }"
        id="search-sidebar-{{ $this->getId() }}"
        data-component-id="{{ $this->getId() }}"
        data-country="{{ $countryCode ?: '' }}"
        :class="{ 'active': openFilter }"
        class="xl:w-[318px] w-full filter-box xl:static fixed -left-full top-0 xl:bg-transparent bg-white xl:h-auto h-full z-[1000]">
        @include('components.frontend.member.sidebar.city-search-sidebar')
    </div>

    <div class="xl:w-[calc(100%_-_318px)] w-full xl:pl-12">
        <div class="hidden justify-between items-center mb-6 xl:flex xl:mb-8">
            <p class="text-xs font-medium leading-4 text-mid-gray">
                {{ __('Showing :first to :last of :total results', [
                    'first' => $members->firstItem() ?? 1,
                    'last' => $members->lastItem() ?? 1,
                    'total' => $members->total(),
                ]) }} {{ $searchForTxt }}
            </p>
            <div class="hidden lg:block">
                <x-frontend.includes.sort-dropdown-desktop :sort="$sort"
                    :sortText="$sortText"
                    component="frontend.member.listing.partials.member-sort-dropdown" />
            </div>
        </div>
        <div class="block w-full xl:hidden">
            <p class="px-6 pb-6 text-xs font-medium leading-4 text-mid-gray">
                {{ __('Showing :first to :last of :total results', [
                    'first' => $members->firstItem(),
                    'last' => $members->lastItem(),
                    'total' => $members->total(),
                ]) }} {{ $searchForTxt }}
            </p>
            <div class="sticky top-0 z-50 px-6 pb-2 bg-white border-b border-solid xl:hidden border-gray-1200">
                <ul class="grid grid-cols-3 gap-3">
                    <li>
                        <a href="javascript:void(0)"
                            @click="$refs.mobileSortModal.showModal()"
                            class="flex items-center  h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                            <x-icon-sort-icon />
                            {{ __('Sort') }}
                        </a>
                    </li>
                    <li>
                        <a href="javascript:void(0)"
                            @click="openFilter = !openFilter"
                            class="filter-btn flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                            <x-icon-list-bars />
                            {{ __('Filters ') }}(4)
                        </a>
                    </li>
                    {{-- <li>
                        <a href="{{ route('member.index', ['view_type' => 'map']) }}" class="flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                            <x-icon-location-outline-v2 />
                            {{ __('Map') }}
                        </a>
                    </li> --}}
                </ul>
            </div>
        </div>
        <div class="relative px-6 pt-8 xl:px-0 xl:py-0">
            <div x-show="memberListLoading" class="absolute inset-0 z-50 w-full h-full bg-white backdrop-blur-sm">
                <x-frontend.includes.loading-overlay-list :rows="6"
                    layout="member-list"
                    class="mt-4" />
            </div>
            @if (!empty($featuredMembers))
                <div>
                    @foreach ($featuredMembers as $member)
                        <x-frontend.member.listing.member-card-featured-gallery :member="$member" />
                    @endforeach
                </div>
            @endif
            @if ($members->isNotEmpty())
                
                <!-- Grid: 6 members -->
                <div class="grid grid-cols-1 gap-6 xl:grid-cols-3 sm:grid-cols-2 xl:gap-8 sm:gap-4">
                    @foreach ($members->except($featuredMembers->pluck('id')->toArray()) as $memberItem)
                        <x-frontend.member.listing.member-card-pro-grid :member="$memberItem" />
                    @endforeach
                </div>

                <!-- Promo between chunks (not after the last chunk) -->
                {{-- @if (!$loop->last)
                    <div class="mt-6 mb-8 sm:my-8">
                        {!! Theme::image('img/city-add-img.png', 'Alt text', 'w-full rounded-lg md:block hidden') !!}
                        <div class="block md:hidden">
                            <x-frontend.ads.ads-list-view-html />
                        </div>
                    </div>
                @endif  --}}

            @endif
            @if ($members->hasPages())
                <div class="mt-11">
                    {{ $members->links('vendor.livewire.esp-sleek-pagination') }}
                </div>
            @endif
        </div>
    </div>
    <!-- Mobile Sort Modal -->
    <x-frontend.includes.sort-modal-mobile :sort="$sort"
        :sortText="$sortText"
        component="frontend.member.listing.partials.member-sort-dropdown" />
</div>
