@props(['viewType' => 'list'])
@php
    use Illuminate\Support\Arr;
    use Illuminate\Support\Str;
    if ($viewType == 'map') {
        $viewClass = 'xl:h-[calc(100vh_-_96px)] xl:overflow-y-auto xl:max-w-[318px] max-w-full shadow-4xl xl:absolute';
    } else {
        $viewClass = 'xl:shadow-4xl xl:w-auto xl:static';
    }
@endphp

<div class="max-w-[1310px] w-full mx-auto lg:px-4 px-0" x-data="initMemberSearch()">
    <div>
        <div class="px-6 lg:px-0">
            {{-- breadcrumb --}}
            <x-frontend.common.breadcrumb-v2 :name="$breadcrumbs['name']" :params="$breadcrumbs['params'] ?? null" />
            <div class="flex flex-col justify-between items-start mt-3 lg:flex-row lg:items-center">
                <div class="w-full lg:w-auto">
                    <h6>{{ Str::headline($page->heading) ?? null }}</h6>
                    <p class="mt-1 text-xs font-medium leading-4 text-mid-gray member-list-results-summery">{{ __('Showing :first to :last of :total results', [
                        'first' => $members->firstItem(),
                        'last' => $members->lastItem(),
                        'total' => $members->total(),
                    ]) }} {{ $searchForTxt }}
                    </p>
                </div>
                <div class="hidden gap-4 items-center lg:flex">
                    <x-frontend.includes.sort-dropdown-desktop :sort="$sort"
                        :sortText="$sortText"
                        component="frontend.member.listing.partials.member-sort-dropdown" />
                    <x-frontend.member.listing.partials.view-type-switcher viewType="{{ $viewType }}" />
                </div>
            </div>
        </div>
    </div>
    {{-- mobile filter --}}
    <div class="block sticky top-0 z-10 px-6 pt-3.5 pb-2 w-full bg-white border-b border-solid lg:hidden border-gray-1200">
        <ul class="grid grid-cols-3 gap-3">
            <li class="flex justify-center items-center">
                <button type="button"
                    @click="$refs.mobileSortModal.showModal()"
                    class="flex items-center  h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-sort-icon />
                    {{ __('Sort') }}
                </button>
            </li>
            <li class="flex justify-center items-center">
                <button type="button"
                    x-on:click="openFilter = !openFilter"
                    class="filter-btn flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-list-bars />
                    {{ __('Filters') }}
                </button>
            </li>
            <li class="flex justify-center items-center">
                <button type="button"
                    data-view-type="map"
                    class="view-type-switch flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                    <x-icon-location-outline-v2 />
                    {{ __('Map') }}
                </button>
            </li>
        </ul>
    </div>

    <div class="flex flex-col-reverse gap-6 px-6 py-8 lg:flex-row xl:gap-10 lg:gap-4 lg:mt-8 lg:px-0 lg:py-0">
        {{-- Sidebar Section --}}
        <div class="lg:w-[318px] w-full">
            <div :class="{ 'active': openFilter }" class="fixed top-0 -left-full w-full h-full bg-white transition-all duration-700 ease-in-out z-100 lg:shadow-5xl lg:rounded-2xl lg:mb-8 filter-box lg:static lg:h-auto">
                <div x-data="{
                    openCategory: @entangle('openCategory').defer,
                    openSubcategory: @entangle('openSubcategory').defer,
                    openSpecificServices: @entangle('openSpecificServices').defer,
                    openRating: @entangle('openRating').defer,
                    openLocation: @entangle('openLocation').defer,
                    openFeatures: @entangle('openFeatures').defer
                }"
                    id="search-sidebar-{{ $this->getId() }}"
                    data-component-id="{{ $this->getId() }}"
                    data-country="{{ $countryCode ?: '' }}"
                    class="bg-white border-solid lg:border border-gray-1200 lg:shadow-5xl lg:rounded-2xl">
                    @include('components.frontend.member.sidebar.search-sidebar-v1')
                </div>
            </div>
            <x-frontend.sidebar.widgets.news-later />
        </div>

        {{-- Results Section --}}
        <div class="lg:w-[calc(100%_-_350px)] w-full relative" wire:key="search-result-list-view">
            <div x-show="memberListLoading" class="absolute inset-0 z-50 w-full h-full bg-white backdrop-blur-sm">
                <x-frontend.includes.loading-overlay-list :rows="6"
                    layout="member-list"
                    class="mt-4" />
            </div>
            <div>
                @if ($members->isNotEmpty())
                    @foreach ($members as $member)
                        @if ($member->membershipType->value === \App\Enums\MembershipType::Featured->value)
                            <x-frontend.member.listing.member-card-featured-gallery :member="$member"
                                :loop="$loop"
                                wire:key="list-member-{{ $member->uuid }}" />
                        @else
                            <x-frontend.member.listing.member-card-pro :member="$member"
                                :loop="$loop"
                                wire:key="list-member-{{ $member->uuid }}" />
                        @endif
                        @if ($loop->iteration % 4 === 0 && !$loop->last)
                            <div class="mb-6">
                                <x-frontend.ads.ads-list-view-html />
                            </div>
                        @endif
                    @endforeach
                    @if ($members->hasPages())
                        <div class="mt-2.5">
                            {{ $members->links('vendor.livewire.esp-sleek-pagination') }}
                        </div>
                    @endif
                @else
                    <x-common.no-records-found>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot:icon>
                        <x-slot:title>
                            {{ __('No results found') }}
                        </x-slot:title>
                        <x-slot:description>
                            {{ __('No results found') }}
                        </x-slot:description>
                    </x-common.no-records-found>
                @endif

            </div>
        </div>
    </div>

    {{-- Mobile Sort Modal --}}
    <x-frontend.includes.sort-modal-mobile :sort="$sort"
        :sortText="$sortText"
        component="frontend.member.listing.partials.member-sort-dropdown" />
</div>
