@php
    use Illuminate\Support\Str;
@endphp
<div x-data="initMemberSearch()">

    <section Class="relative result-map-sec lg:h-[calc(100vh_-_88px)] h-[calc(100vh_-_69px)]">
        <div class="block sticky top-0 z-50 px-6 pt-6 pb-2 w-full bg-white border-b border-solid lg:hidden border-gray-1200">
            <ul class="grid grid-cols-3 gap-3">
                <li class="flex items-center justify-center">
                    <button type="button"
                        @click="$refs.mobileSortModal.showModal()"
                        class="flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                        <x-icon-sort-icon />
                        {{ __('Sort') }}
                    </button>
                </li>
                <li class="flex items-center justify-center">
                    <button x-on:click="openFilter = !openFilter" class="filter-map-btn flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                        <x-icon-list-bars />
                        {{ __('Filters') }}
                    </button>
                </li>
                <li class="flex items-center justify-center">
                    <button type="button"
                        data-view-type="list"
                        class="view-type-switch flex items-center h-10 justify-center text-primary-blue text-sm font-medium tracking-[-0.096px] gap-1.5">
                        <x-icon-list-icon />
                        {{ __('List') }}
                    </button>
                </li>
            </ul>
        </div>
        <div class="flex lg:flex-row flex-col lg:h-full h-[calc(100%_-_73px)]">
            <div class="hidden xl:w-[766px] w-[652px] lg:block">
                <div class="pt-8 pr-4 pl-4 2xl:pl-10 2xl:pr-6">
                    <x-frontend.common.breadcrumb-v2 :name="$breadcrumbs['name']" :params="$breadcrumbs['params'] ?? null" />
                    <div class="mt-3">
                        <h6>{{ Str::headline($page->heading) }}</h6>
                        <p class="mt-1 text-xs font-medium leading-4 text-mid-gray member-list-results-summery">
                            {{ __('Showing :first to :last of :total results', [
                                'first' => $members->firstItem(),
                                'last' => $members->lastItem(),
                                'total' => $members->total(),
                            ]) }} {{ $searchForTxt }}
                        </p>
                    </div>

                    <div class="mt-6 mb-7">
                        <div class="flex justify-between items-center">
                            <button @click="openFilter = true"
                                href="#"
                                class="filter-map-btn text-black-1200 font-normal text-sm leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full shadow-3xl h-10 inline-flex cursor-pointer items-center justify-center gap-3 px-[11px] hover:bg-gray-1400 hover:border-gray-1400 hover:text-mid-gray transition-all duration-500 ease-in-out">
                                <x-icon-advance-filter />
                                {{ __('Filters') }}
                            </button>

                            <div class="hidden gap-4 items-center lg:flex">
                                <x-frontend.includes.sort-dropdown-desktop :sort="$sort"
                                    :sortText="$sortText"
                                    component="frontend.member.listing.partials.member-sort-dropdown" />
                                <x-frontend.member.listing.partials.view-type-switcher viewType="{{ $viewType }}" />
                            </div>
                        </div>
                    </div>

                    <div class="xl:pr-4 pr-2.5 h-[calc(100vh_-_296px)] overflow-y-auto -ml-8 -mt-5">
                        {{-- <div x-show="memberListLoading" class="absolute inset-0 z-10 bg-white backdrop-blur-sm">
                            <x-frontend.includes.loading-overlay-list :rows="6"
                                layout="member-list"
                                class="mt-4" />
                        </div> --}}
                        <div class="pl-8 pt-5">
                            @if ($members->isNotEmpty())
                                @foreach ($members as $member)
                                    @if ($member->membershipType->value === \App\Enums\MembershipType::Featured->value)
                                        <x-frontend.member.listing.member-card-featured-gallery :member="$member"
                                            :loop="$loop"
                                            wire:key="map-member-{{ $member->uuid }}" />
                                    @else
                                        <x-frontend.member.listing.member-card-pro :member="$member"
                                            :loop="$loop"
                                            wire:key="map-member-{{ $member->uuid }}" />
                                    @endif
                                    @if ($loop->iteration % 4 === 0 && !$loop->last)
                                        <div class="mb-6">
                                            <x-frontend.ads.ads-list-view-html />
                                        </div>
                                    @endif
                                @endforeach
                            @else
                                <x-common.no-records-found>
                                    <x-slot:icon>
                                        <x-icon-search-icon />
                                    </x-slot:icon>
                                    <x-slot:title>
                                        {{ __('No results found') }}
                                    </x-slot:title>
                                    <x-slot:description>
                                        {{ __('Try to adjust your search filters.') }}
                                    </x-slot:description>
                                </x-common.no-records-found>
                            @endif
                        </div>
                        <div class="mt-2.5 mb-2.5">
                            {{ $members->links('vendor.livewire.esp-sleek-pagination') }}
                        </div>
                    </div>
                </div>
            </div>

            <div class="xl:w-[calc(100%_-_766px)] lg:w-[calc(100%_-_652px)] w-full relative max-w-full flex-1 h-full" x-data="{ mapLoading: @entangle('mapLoading').live }">
                <!-- Mobile Pagination Overlay -->
                @if ($members->hasPages())
                    <div class="flex absolute top-0 right-0 left-0 z-50 justify-between items-center px-4 py-3 w-full bg-black/70 lg:hidden">
                        <!-- Results count on the left -->
                        <div class="text-xs font-medium text-white">
                            {{ __('Showing :first-:last of :total', [
                                'first' => $members->firstItem(),
                                'last' => $members->lastItem(),
                                'total' => $members->total(),
                            ]) }}
                        </div>

                        <!-- Navigation buttons on the right -->
                        <div class="flex gap-2 items-center">
                            <!-- Previous button -->
                            @if ($members->onFirstPage())
                                <button disabled class="flex justify-center items-center w-8 h-8 rounded-full border opacity-50 cursor-not-allowed border-white/30 bg-white/10">
                                    <x-icon-left-arrow2 class="w-3 h-3 text-white" />
                                </button>
                            @else
                                <button wire:click="previousPage"
                                    wire:loading.attr="disabled"
                                    @click="mapLoading = true"
                                    class="flex justify-center items-center w-8 h-8 rounded-full border transition-colors border-white/50 bg-white/20 hover:bg-white/30">
                                    <x-icon-left-arrow2 class="w-3 h-3 text-white" />
                                </button>
                            @endif

                            <!-- Next button -->
                            @if ($members->hasPages())
                                <button wire:click="nextPage"
                                    wire:loading.attr="disabled"
                                    @click="mapLoading = true"
                                    class="flex justify-center items-center w-8 h-8 rounded-full border transition-colors border-white/50 bg-white/20 hover:bg-white/30">
                                    <x-icon-right-arrow2 class="w-3 h-3 text-white" />
                                </button>
                            @else
                                <button disabled class="flex justify-center items-center w-8 h-8 rounded-full border opacity-50 cursor-not-allowed border-white/30 bg-white/10">
                                    <x-icon-right-arrow2 class="w-3 h-3 text-white" />
                                </button>
                            @endif
                        </div>
                    </div>
                @endif

                <!-- Map Loading Overlay -->
                <div x-show="mapLoading"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0"
                    x-transition:enter-end="opacity-100"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100"
                    x-transition:leave-end="opacity-0"
                    class="flex absolute inset-0 z-40 justify-center items-center backdrop-blur-sm bg-white/80 lg:hidden"
                    style="display: none;">
                    <div class="flex flex-col justify-center items-center p-6 bg-white rounded-xl border border-gray-200 shadow-lg">
                        <div class="mb-3 w-12 h-12">
                            <img src="{{ theme_asset('img/loading.png') }}"
                                alt="Loading"
                                class="w-full h-full animate-pulse">
                        </div>
                        <div class="text-sm font-medium text-gray-700">
                            {{ __('Loading members...') }}
                        </div>
                    </div>
                </div>

                <!-- Map Overlay -->
                <!-- Actual map container -->
                <div id="esp-directory-map"
                    wire:ignore
                    class="w-full h-full"></div>
            </div>
        </div>
    </section>

    <!----- FILTER ------>
    <div x-data="{
        openCategory: @entangle('openCategory').defer,
        openSubcategory: @entangle('openSubcategory').defer,
        openSpecificServices: @entangle('openSpecificServices').defer,
        openRating: @entangle('openRating').defer,
        openLocation: @entangle('openLocation').defer,
        openFeatures: @entangle('openFeatures').defer
    }"
        class="fixed top-0 -left-full z-50 w-full h-full transition-all duration-500 ease-in-out map-filter lg:p-6 lg:w-auto"
        :class="{ 'active': openFilter }">
        <div class="bg-white border-solid lg:border border-gray-1200 lg:shadow-5xl lg:rounded-2xl">
            @include('components.frontend.member.sidebar.search-sidebar-v1')
        </div>
        <a href="#"
            @click="openFilter = false"
            class="hidden absolute -right-2 top-6 justify-center items-center w-6 h-6 bg-white rounded-full border border-solid filter-close border-gray-1200 shadow-3xl lg:flex text-[#525866]">
            <x-icon-close-icon />
        </a>
    </div>
    <div class="overly lg:block hidden z-40 fixed left-0 top-0 opacity-0 invisible w-full h-full bg-black-1400/[0.24] transition-all duration-500 ease-in-out" :class="{ 'active': openFilter }"></div>

    {{-- Mobile Sort Modal --}}
    <x-frontend.includes.sort-modal-mobile :sort="$sort"
        :sortText="$sortText"
        component="frontend.member.listing.partials.member-sort-dropdown" />

</div>
