<div x-data class="relative h-full bg-white md:h-auto">
    <a href="javascript:void(0)"
        onclick="Livewire.dispatch('closeModal')"
        class="flex absolute top-6 right-6 justify-center items-center w-6 h-6 md:right-4 md:top-4">
        <x-icon-close-icon />
    </a>

    <!-- Modal body -->
    <div class="p-6 md:p-10">
        <div class="mb-6 md:mb-12">
            {{-- @dump($member->memberName()) --}}
            <h4 class="text-black-1200 font-medium md:text-xl text-lg md:leading-7 leading-6 md:tracking-normal tracking-[-0.24px]">{{ __('Contact') }} {{ $member?->memberName() }} </h4>
            <p class="mt-1 text-xs font-medium leading-5 text-mid-gray">
                {{ __('One liner sub text here') }}
            </p>
        </div>
        <form wire:submit="sendMessage">
            @csrf
            @if (session()->has('success'))
                <div class="flex items-center p-4 mb-4 text-sm text-green-800 bg-green-300 rounded-lg border border-green-300" role="alert">
                    <x-icon-check-icon />
                    <div class="px-2 font-medium">
                        {{ session()->get('success') }}
                    </div>
                </div>
            @endif
            @if (session()->has('error'))
                <div class="flex items-center p-4 mb-4 text-sm text-red-500 bg-red-300 rounded-lg border border-red-300" role="alert">
                    <x-icon-close-icon />
                    <div class="px-2 font-medium">
                        {{ session()->get('error') }}
                    </div>
                </div>
            @endif
            <div class="mb-6">
                <label class="flex items-center font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                    {{ __('FullName') }}
                </label>
                <input type="text"
                    wire:model="name"
                    class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                    placeholder="{{ __('e.g Jhon Doe') }}" />
                @error('name')
                    <p class="mt-2 text-xs text-red-500">{{ $message }}</p>
                @enderror
            </div>
            <div class="mb-6">
                <label class="flex items-center font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                    {{ __('Email') }}
                    <span class="text-primary-blue">*</span>
                </label>
                <input type="text"
                    wire:model="email"
                    class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                    placeholder="{{ __('hello@eps.com') }}" />
                @error('email')
                    <p class="mt-2 text-xs text-red-500">{{ $message }}</p>
                @enderror
            </div>
            <div class="mb-6">
                <label class="flex items-center font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                    {{ __('Phone Number') }}
                    <span class="text-primary-blue">*</span>
                </label>
                <input id="phone"
                    type="tel"
                    wire:model="phone"
                    class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                    placeholder="{{ __('(555) 000-0000') }}" />
                <p id="output" class="mt-2 text-xs text-gray-500"></p>
                @error('phone')
                    <p class="mt-2 text-xs text-red-500">{{ $message }}</p>
                @enderror
            </div>
            <div class="mb-6">
                <label class="flex items-center font-medium text-sm leading-5 tracking-[-0.096px] mb-1">{{ __('Message') }}
                    <span class="text-primary-blue">*</span></label>
                <div x-data="{ message: '', max: 200 }" class="flex relative flex-col experience-block">
                    <textarea wire:model="message"
                        x-model="message"
                        :maxlength="max"
                        rows="5"
                        class="myTextarea border border-solid border-gray-1200 rounded-xl h-[151px] w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500"
                        placeholder="{{ __('Start writing here...') }}">
                    </textarea>
                    <div class="counter absolute right-7 bottom-2.5 text-gray-1500 font-medium text-[11px] leading-3 tracking-[0.32px]">
                        <span x-text="message.length"></span> {{ __('/') }} <span x-text="max"></span>
                    </div>
                </div>
                @error('message')
                    <p class="mt-2 text-xs text-red-500">{{ $message }}</p>
                @enderror
            </div>
            <div class="flex justify-start mb-16">
                <x-captcha-livewire-field wire-model="captchaToken"
                    action="contact_modal"
                    version="v3"
                    :show-error="true"
                    field-class="flex justify-center" />
                @error('captchaToken')
                    <span class="text-sm text-red-500">{{ $message }}</span>
                @enderror
            </div>
            <div>
                <button type="submit" class="cursor-pointer text-white font-medium text-sm leading-5 tracking-[-0.096px] rounded-full mx-auto bg-black-1200 flex items-center justify-center h-10 w-full">
                    {{ __('Send Message') }}
                    <span wire:loading
                        wire:target="sendMessage"
                        class="inline-flex items-center ml-2">
                        <svg class="mr-3 -ml-1 w-5 h-5 text-white animate-spin"
                            xmlns="http://www.w3.org/2000/svg"
                            fill="none"
                            viewBox="0 0 24 24">
                            <circle class="opacity-25"
                                cx="12"
                                cy="12"
                                r="10"
                                stroke="currentColor"
                                stroke-width="4"></circle>
                            <path class="opacity-75"
                                fill="currentColor"
                                d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                    </span>
                </button>
            </div>
        </form>
    </div>

</div>
