@php
    use ProtoneMedia\LaravelFFMpeg\Support\FFMpeg;
    use Illuminate\Support\Facades\Storage;
    use Illuminate\Support\Number;

    $videoFileUrl = $video->getFirstMediaUrl('video');
    $media = $video->media('video')->first();
    $videoPath = $media->getPath();
    $duration = FFMpeg::fromDisk($media->disk)->open($media->getPathRelativeToRoot())->getDurationInSeconds();
    $duration = gmdate('i:s', $duration);
@endphp
<!-- Main modal -->

<div class="relative bg-black md:rounded-3xl">
    <a href="javascript:void(0)"
        onclick="Livewire.dispatch('closeModal')"
        data-modal-hide="default-modal3"
        class="hidden absolute top-6 right-6 justify-center items-center w-6 h-6 md:flex md:right-4 md:top-4 text-white">
        <x-icon-close-icon />
    </a>

    <!-- Modal body -->
    <div class="md:p-10 sm:p-0">
        <div class="p-6">
            <a href="javascript:void(0)"
                onclick="Livewire.dispatch('closeModal')"
                class="flex items-center flex-start text-white"
                data-modal-hide="default-modal3">
                <x-icon-arrow-left-outline />
            </a>
        </div>
        <div class="flex items-center flex-col xl:h-[500px] md:h-[350px] h-[200px]">
            @if ($video->getFirstMediaUrl('video'))
                <video class="rounded-xl" controls>
                    <source src="{{ $video->getFirstMediaUrl('video') }}" type="video/mp4">
                    <source src="{{ $video->getFirstMediaUrl('video') }}" type="video/webp">
                    <source src="{{ $video->getFirstMediaUrl('video') }}" type="video/ogg">
                    <source src="{{ $video->getFirstMediaUrl('video') }}" type="video/ogv">
                    <source src="{{ $video->getFirstMediaUrl('video') }}" type="video/webm">
                    {{ __('Your browser does not support the video tag.') }}
                </video>
            @else
                <img src="{{ $video->getFirstMediaUrl('video', 'thumb') }}"
                    alt="{{ $video->video_title }}"
                    class="w-full h-full rounded-xl" />
            @endif
        </div>
        <div class="p-6 md:mt-12 md:p-0">
            <h5 class="text-xl font-medium leading-7 md:text-2xl md:leading-8 text-white ">{{ $video->video_title }}</h5>
            <div class="flex gap-2 items-center mt-5">
                <span class="flex justify-center items-center p-1 w-12 h-12 rounded-full border border-solid border-gray-1200">
                    <x-frontend.member.profile.partials.profile-avatar :user="$video->user" class="rounded-full" />
                </span>
                <div class="flex flex-col flex-1 justify-between items-start w-full md:flex-row md:items-center">
                    <div class="flex gap-9 justify-between items-center w-full md:justify-start md:w-auto">
                        <div>
                            @if ($video->author)
                                <h4 class="text-white font-medium text-sm leading-6 tracking-[-0.176px] my-2">
                                    {{ $video->author->memberName() }}
                                </h4>
                            @endif
                            <ul class="flex gap-1.5 items-center mt-2">
                                @if ($video->views)
                                    <li class="text-white font-medium text-[11px] leading-3 tracking-[0.32px]">
                                        {{ $video->views }}
                                        {{ __('views') }}
                                    </li>
                                    <li><span class="flex items-center justify-center rounded-full bg-gray-1500 w-[3px] h-[3px]"></span>
                                    </li>
                                @endif
                                @if (!empty($video->likes))
                                    <li class="text-white font-medium text-[11px] leading-3 tracking-[0.32px]">
                                        {{ $video->likes }}
                                        {{ __('likes') }}
                                    </li>
                                    <li><span class="flex items-center justify-center rounded-full bg-gray-1500 w-[3px] h-[3px]"></span>
                                    </li>
                                @endif
                                @if ($video->created_at)
                                    <li class="text-white font-medium text-[11px] leading-3 tracking-[0.32px]">
                                        {{ $video->created_at->diffForHumans() }}
                                    </li>
                                @endif
                            </ul>
                        </div>
                        <a href="#" class="inline-flex items-center text-sm font-medium leading-5 tracking-[-0.096px] gap-2.5 rounded-full h-10 px-3 bg-gray-1400">
                            <x-icon-like-icon />
                            {{ __('Like') }}
                        </a>
                    </div>

                    <div class="hidden">
                        <ul class="flex gap-3 items-center">
                            <li>
                                <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                                    <x-icon-facebook />
                                </a>
                            </li>
                            <li>
                                <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                                    <x-icon-twitter-x />
                                </a>
                            </li>
                            <li>
                                <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                                    <x-icon-linkedin />
                                </a>
                            </li>
                            <li>
                                <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                                    <x-icon-instagram />
                                </a>
                            </li>
                            <li>
                                <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                                    <x-icon-link />
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
        <div class="px-6 pb-6 md:hidden">
            <h5 class="text-base font-medium leading-6 mb-3 tracking-[-0.176px]">Share video</h5>
            <ul class="flex gap-3 items-center">
                <li>
                    <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                        <x-icon-facebook />
                    </a>
                </li>
                <li>
                    <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                        <x-icon-twitter-x />
                    </a>
                </li>
                <li>
                    <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                        <x-icon-linkedin />
                    </a>
                </li>
                <li>
                    <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                        <x-icon-instagram />
                    </a>
                </li>
                <li>
                    <a href="#" class="flex justify-center items-center w-10 h-10 rounded-full bg-gray-1400">
                        <x-icon-link />
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
