<div class="relative h-full bg-white md:rounded-xl md:h-auto">
    <a href="javascript:void(0)" onclick="Livewire.dispatch('closeModal')" class="hidden absolute top-4 right-4 justify-center items-center w-6 h-6 cursor-pointer md:flex">
        <x-icon-close-icon />
    </a>

    @if ($showSuccessModal)
        <div class="flex fixed inset-0 z-50 justify-center items-center bg-black bg-opacity-50" x-data="{ show: true }" x-show="show" x-init="setTimeout(() => { Livewire.dispatch('closeModal'); }, 2000)">
            <div class="p-8 mx-auto max-w-md text-center bg-white rounded-xl">
                <div class="mb-4">
                    <svg class="mx-auto w-16 h-16 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <h3 class="mb-2 text-xl font-semibold text-gray-900">{{ __('Review Submitted Successfully!') }}</h3>
                <p class="text-gray-600">{{ __('Thank you for sharing your experience.') }}</p>
            </div>
        </div>
    @endif

    @if (!$this->isAuthenticated())
        <div class="flex flex-col justify-center items-center px-6 h-96">
            <div class="text-center">
                <svg class="mx-auto mb-4 w-20 h-20 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                </svg>
                <h3 class="mb-2 text-xl font-semibold text-gray-900">{{ __('Login Required') }}</h3>
                <p class="mb-6 text-gray-600">{{ __('Please login to write a review for :member', ['member' => $member->memberName()]) }}</p>
                <div class="flex gap-3 justify-center">
                    <a href="{{ route('login') }}" class="px-6 py-2 text-sm font-medium text-white rounded-full transition-colors cursor-pointer bg-primary-blue hover:bg-blue-600">
                        {{ __('Login') }}
                    </a>
                    <a href="{{ route('register') }}" class="px-6 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-full transition-colors cursor-pointer hover:bg-gray-200">
                        {{ __('Sign Up') }}
                    </a>
                </div>
            </div>
        </div>
    @elseif(!$this->canWriteReview())
        <div class="flex flex-col justify-center items-center px-6 h-96">
            <div class="text-center">
                <svg class="mx-auto mb-4 w-20 h-20 text-orange-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-2.5L13.732 4c-.77-.833-1.732-.833-2.464 0L4.35 16.5c-.77.833.192 2.5 1.732 2.5z"></path>
                </svg>
                <h3 class="mb-2 text-xl font-semibold text-gray-900">{{ __('Cannot Write Self-Review') }}</h3>
                <p class="mb-6 text-gray-600">{{ __('You cannot write a review for your own profile. Reviews should be written by other users who have experience working with you.') }}</p>
                <button onclick="Livewire.dispatch('closeModal')" class="px-6 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-full transition-colors cursor-pointer hover:bg-gray-200">
                    {{ __('Close') }}
                </button>
            </div>
        </div>
    @else
        <form wire:submit.prevent="submitReview">
            <div class="flex flex-col md:flex-row md:rounded-xl">
                <div class="p-3 max-w-[270px] md:block hidden">
                    <div class="bg-gray-1400 h-full px-4 pb-4 pt-8 rounded-2xl lg:max-w-[318px] md:max-w-[250px] max-w-full w-full">
                        <div class="">
                            <h4 class="mb-1 text-xl font-medium leading-7 text-black-1200">{{ __('Write a Review') }}</h4>
                            <p class="text-xs font-medium leading-4 text-mid-gray">
                                {{ __('Share your experience & help others make informed decisions about :member', ['member' => $member->memberName()]) }}
                            </p>
                        </div>
                        <div class="mt-3">
                            <ol class="flex gap-3 items-center sm:block">
                                <li class="sm:mb-2">
                                    <a href="#" wire:click.prevent="goToStep(1)" class="step-link w-full flex items-center gap-2 rounded-[10px] p-2 cursor-pointer {{ $currentStep === 1 ? 'bg-primary-blue text-white' : ($currentStep > 1 ? 'complete' : '') }}" data-step="1">
                                        <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 {{ $currentStep === 1 ? 'bg-white text-primary-blue' : 'bg-white' }} rounded-full number-box shadow-3xl">
                                            @if ($currentStep > 1)
                                                <span class="text-green-500">
                                                    <x-icon-check-icon />
                                                </span>
                                            @else
                                                <span class="step-number">1</span>
                                            @endif
                                        </span>
                                        <p class="flex-1 w-full flex items-center justify-between text-sm font-normal leading-5 tracking-[-0.096px] {{ $currentStep === 1 ? 'text-white' : 'text-mid-gray' }}">
                                            {{ 'Overall Experience' }}
                                            @if ($currentStep === 1)
                                                <span class="flex justify-center items-center w-5 h-5">
                                                    <x-icon-right-arrow />
                                                </span>
                                            @endif
                                        </p>
                                    </a>
                                </li>
                                <li class="sm:mb-2">
                                    <a href="#" wire:click.prevent="goToStep(2)" class="step-link w-full flex items-center gap-2 rounded-[10px] p-2 cursor-pointer {{ $currentStep === 2 ? 'bg-primary-blue text-white' : ($currentStep > 2 ? 'complete' : '') }}" data-step="2">
                                        <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 {{ $currentStep === 2 ? 'bg-white text-primary-blue' : 'bg-white' }} rounded-full number-box shadow-3xl">
                                            @if ($currentStep > 2)
                                                <span class="text-green-500">
                                                    <x-icon-check-icon />
                                                </span>
                                            @else
                                                <span class="step-number">2</span>
                                            @endif
                                        </span>
                                        <p class="flex-1 w-full flex items-center justify-between text-sm font-normal leading-5 tracking-[-0.096px] {{ $currentStep === 2 ? 'text-white' : 'text-mid-gray' }}">
                                            {{ __('How things went') }}
                                            @if ($currentStep === 2)
                                                <span class="flex justify-center items-center w-5 h-5">
                                                    <x-icon-right-arrow />
                                                </span>
                                            @endif
                                        </p>
                                    </a>
                                </li>
                                <li class="sm:mb-2">
                                    <a href="#" wire:click.prevent="goToStep(3)" class="step-link w-full flex items-center gap-2 rounded-[10px] p-2 cursor-pointer {{ $currentStep === 3 ? 'bg-primary-blue text-white' : ($currentStep > 3 ? 'complete' : '') }}" data-step="3">
                                        <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 {{ $currentStep === 3 ? 'bg-white text-primary-blue' : 'bg-white' }} rounded-full number-box shadow-3xl">
                                            @if ($currentStep > 3)
                                                <span class="text-green-500">
                                                    <x-icon-check-icon />
                                                </span>
                                            @else
                                                <span class="step-number">3</span>
                                            @endif
                                        </span>
                                        <p class="flex-1 w-full flex items-center justify-between text-sm font-normal leading-5 tracking-[-0.096px] {{ $currentStep === 3 ? 'text-white' : 'text-mid-gray' }}">
                                            {{ __('Upload Photos') }}
                                            @if ($currentStep === 3)
                                                <span class="flex justify-center items-center w-5 h-5">
                                                    <x-icon-right-arrow />
                                                </span>
                                            @endif
                                        </p>
                                    </a>
                                </li>
                                <li class="flex gap-2 items-center">
                                    <a href="#" wire:click.prevent="goToStep(4)" class="step-link w-full flex items-center gap-2 rounded-[10px] p-2 cursor-pointer {{ $currentStep === 4 ? 'bg-primary-blue text-white' : '' }}" data-step="4">
                                        <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 {{ $currentStep === 4 ? 'bg-white text-primary-blue' : 'bg-white' }} rounded-full number-box shadow-3xl">
                                            <span class="step-number">4</span>
                                        </span>
                                        <p class="flex-1 w-full flex items-center justify-between text-sm font-normal leading-5 tracking-[-0.096px] {{ $currentStep === 4 ? 'text-white' : 'text-mid-gray' }}">
                                            {{ __('Summary') }}
                                            @if ($currentStep === 4)
                                                <span class="flex justify-center items-center w-5 h-5">
                                                    <x-icon-right-arrow />
                                                </span>
                                            @endif
                                        </p>
                                    </a>
                                </li>
                            </ol>
                        </div>
                    </div>
                </div>

                <div class="flex-1 w-full bg-white md:rounded-r-xl">
                    <!-- Step 1: Overall Experience -->
                    <div id="step1" class="step" style="{{ $currentStep === 1 ? 'display: block;' : 'display: none;' }}">
                        <div class="flex gap-4 justify-start items-center px-6 pt-6 pb-3 border-b border-solid md:hidden border-gray-1200">
                            <button type="button" class="inline-flex justify-center items-center w-10 h-10 rounded-full border border-solid shadow-3xl border-gray-1200">
                                <x-icon-menu-icon-v2 />
                            </button>
                            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                                {{ __('Overall Experience') }}
                            </h4>
                        </div>
                        <div class="px-6 py-8 lg:pl-5 lg:pr-10 md:px-4 lg:py-10 md:py-5">
                            <div>
                                <div class="">
                                    <h4 class="mb-1 text-xl font-medium leading-7 text-black-1200">
                                        {{ __('How Was Your Overall Experience?') }}
                                    </h4>
                                    <p class="text-xs font-medium leading-4 text-mid-gray">
                                        {{ __('Share your thoughts on your overall experience with :member', ['member' => $member->memberName()]) }}
                                    </p>
                                </div>
                                <div class="mt-4 md:mt-8">
                                    <label class="text-black-1200 font-medium text-sm tracking-[-0.096px] leading-5 mb-2 flex items-center">
                                        {{ __('Rating') }} <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{ hoverRating: 0, rating: @entangle('overallRating') }">
                                        <ul class="flex gap-2 items-center">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <li>
                                                    <button type="button" @mouseenter="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0" @click="rating = {{ $i }}; $wire.set('overallRating', {{ $i }})" class="flex items-center transition-all duration-200 cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 transition-all duration-200" :class="(hoverRating >= {{ $i }} || rating >= {{ $i }}) ? 'text-[#335CFF] fill-current' : 'text-gray-300'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </button>
                                                </li>
                                            @endfor
                                        </ul>
                                        @if ($overallRating > 0)
                                            <p class="mt-2 text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($overallRating) }}
                                            </p>
                                        @endif
                                    </div>
                                    @error('overallRating')
                                        <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="mt-6 md:mt-8">
                                    <label class="text-black-1200 gap-1 font-medium text-sm tracking-[-0.096px] leading-5 mb-1 flex items-center">
                                        {{ __('Review Title') }}
                                        <span class="text-mid-gray">({{ __('Optional') }})</span>
                                    </label>
                                    <input type="text" wire:model="reviewTitle" maxlength="255" class="px-3 w-full h-10 text-sm font-normal rounded-full border border-solid text-gray-1500 placeholder:text-gray-1500 shadow-3xl border-gray-1200 focus:border-gray-1200 outline-0 focus:ring-0" placeholder="Summarize your experience in a few words..." />
                                    @error('reviewTitle')
                                        <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <div class="mt-6 md:mt-8">
                                    <label class="text-black-1200 gap-1 font-medium text-sm tracking-[-0.096px] leading-5 mb-1 flex items-center">
                                        {{ __('Description') }} <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{
                                        description: @entangle('reviewDescription'),
                                        max: 5000,
                                        min: 50,
                                        get count() {
                                            return this.description ? this.description.length : 0;
                                        },
                                        get counterColor() {
                                            if (this.count < this.min) return 'text-red-500';
                                            if (this.count >= this.min && this.count < 100) return 'text-orange-500';
                                            return 'text-gray-1500';
                                        }
                                    }" class="relative experience-block">
                                        <textarea x-model="description" :maxlength="max" rows="5" class="myTextarea text-gray-1500 placeholder:text-gray-1500 font-normal text-sm h-[131px] shadow-3xl px-3 py-2 w-full rounded-xl border border-solid border-gray-1200 focus:border-gray-1200 outline-0 focus:ring-0" placeholder="{{ __('Start writing here...') }}">
                                    </textarea>
                                        <div class="counter absolute right-7 bottom-2.5 font-medium text-[11px] leading-3 tracking-[0.32px]" :class="counterColor">
                                            <span x-text="count"></span> {{ __('/') }} <span x-text="max"></span>
                                        </div>
                                    </div>
                                    <p class="flex gap-1 items-center mt-1 text-xs font-normal leading-4 text-mid-gray">
                                        <span class="flex items-center justify-center w-4 h-4 text-[#99A0AE]">
                                            <x-icon-info-icon-v2 />
                                        </span>
                                        {{ __('Minimum character length is 50') }}
                                    </p>
                                    @error('reviewDescription')
                                        <span class="mt-1 text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="flex justify-end items-end px-6 pb-4 mt-0 md:pl-4 lg:pr-10 md:pr-4 lg:pb-10 md:mt-6">
                            <div class="relative overflow-hidden md:w-[89px] w-full h-10">
                                <x-frontend.includes.modal-element-loading wire:loading wire:target="nextStep" class="rounded-full" />
                                <button
                                    type="button"
                                    wire:click="nextStep"
                                    class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-10 w-full rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors"
                                    wire:loading.attr="disabled"
                                    wire:target="nextStep"
                                >
                                    <span>{{ __('Continue') }}</span>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Step 2: How Things Went -->
                    <div id="step2" class="step" style="{{ $currentStep === 2 ? 'display: block;' : 'display: none;' }}">
                        <div class="flex gap-4 justify-start items-center px-6 pt-6 pb-3 border-b border-solid md:hidden border-gray-1200">
                            <button type="button" wire:click="previousStep" class="inline-flex justify-center items-center w-10 h-10 rounded-full shadow-3xl border border-solid border-gray-1200 text-[#525866] cursor-pointer hover:bg-gray-50 transition-colors">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                </svg>
                            </button>
                            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                                {{ __('How Things Went') }}
                            </h4>
                        </div>
                        <div class="px-6 py-8 lg:pl-5 lg:pr-10 md:px-4 lg:py-10 md:py-5">
                            <div class="">
                                <h4 class="mb-1 text-xl font-medium leading-7 text-black-1200">
                                    {{ __('Share How Things Went?') }}
                                </h4>
                                <p class="text-xs font-medium leading-4 text-mid-gray">
                                    {{ __('Evaluate different aspects of the service you received from :member', ['member' => $member->memberName()]) }}
                                </p>
                            </div>
                            <div class="mt-6 md:mt-12">
                                <!-- Service Quality Rating -->
                                <div class="mb-6">
                                    <label class="text-black-1200 font-medium text-sm tracking-[-0.096px] leading-5 flex items-center">
                                        {{ __('Service Quality') }}
                                        <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{ hoverRating: 0, rating: @entangle('serviceQualityRating') }">
                                        <ul class="flex gap-2 items-center my-2">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <li>
                                                    <button type="button" @mouseenter="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0" @click="rating = {{ $i }}; $wire.set('serviceQualityRating', {{ $i }})" class="flex items-center cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 transition-all duration-200" :class="(hoverRating >= {{ $i }} || rating >= {{ $i }}) ? 'text-[#335CFF] fill-current' : 'text-gray-300'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </button>
                                                </li>
                                            @endfor
                                        </ul>
                                        <p class="h-4 text-xs font-semibold leading-4 text-black-1200" :class="(hoverRating > 0 || rating > 0) ? 'visible' : 'invisible'" x-text="hoverRating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][hoverRating - 1] : (rating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][rating - 1] : 'placeholder')">
                                        </p>
                                    </div>
                                    @error('serviceQualityRating')
                                        <span class="text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Response Time Rating -->
                                <div class="mb-6">
                                    <label class="text-black-1200 font-medium text-sm tracking-[-0.096px] leading-5 flex items-center">
                                        {{ __('Response Time') }}
                                        <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{ hoverRating: 0, rating: @entangle('responseTimeRating') }">
                                        <ul class="flex gap-2 items-center my-2">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <li>
                                                    <button type="button" @mouseenter="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0" @click="rating = {{ $i }}; $wire.set('responseTimeRating', {{ $i }})" class="flex items-center cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 transition-all duration-200" :class="(hoverRating >= {{ $i }} || rating >= {{ $i }}) ? 'text-[#335CFF] fill-current' : 'text-gray-300'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </button>
                                                </li>
                                            @endfor
                                        </ul>
                                        <p class="h-4 text-xs font-semibold leading-4 text-black-1200" :class="(hoverRating > 0 || rating > 0) ? 'visible' : 'invisible'" x-text="hoverRating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][hoverRating - 1] : (rating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][rating - 1] : 'placeholder')">
                                        </p>
                                    </div>
                                    @error('responseTimeRating')
                                        <span class="text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Professionalism Rating -->
                                <div class="mb-6">
                                    <label class="text-black-1200 font-medium text-sm tracking-[-0.096px] leading-5 flex items-center">
                                        {{ __('Professionalism') }}
                                        <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{ hoverRating: 0, rating: @entangle('professionalismRating') }">
                                        <ul class="flex gap-2 items-center my-2">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <li>
                                                    <button type="button" @mouseenter="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0" @click="rating = {{ $i }}; $wire.set('professionalismRating', {{ $i }})" class="flex items-center cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 transition-all duration-200" :class="(hoverRating >= {{ $i }} || rating >= {{ $i }}) ? 'text-[#335CFF] fill-current' : 'text-gray-300'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </button>
                                                </li>
                                            @endfor
                                        </ul>
                                        <p class="h-4 text-xs font-semibold leading-4 text-black-1200" :class="(hoverRating > 0 || rating > 0) ? 'visible' : 'invisible'" x-text="hoverRating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][hoverRating - 1] : (rating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][rating - 1] : 'placeholder')">
                                        </p>
                                    </div>
                                    @error('professionalismRating')
                                        <span class="text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Value for Money Rating -->
                                <div class="mb-6">
                                    <label class="text-black-1200 font-medium text-sm tracking-[-0.096px] leading-5 flex items-center">
                                        {{ __('Value for Money') }}
                                        <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{ hoverRating: 0, rating: @entangle('valueForMoneyRating') }">
                                        <ul class="flex gap-2 items-center my-2">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <li>
                                                    <button type="button" @mouseenter="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0" @click="rating = {{ $i }}; $wire.set('valueForMoneyRating', {{ $i }})" class="flex items-center cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 transition-all duration-200" :class="(hoverRating >= {{ $i }} || rating >= {{ $i }}) ? 'text-[#335CFF] fill-current' : 'text-gray-300'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </button>
                                                </li>
                                            @endfor
                                        </ul>
                                        <p class="h-4 text-xs font-semibold leading-4 text-black-1200" :class="(hoverRating > 0 || rating > 0) ? 'visible' : 'invisible'" x-text="hoverRating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][hoverRating - 1] : (rating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][rating - 1] : 'placeholder')">
                                        </p>
                                    </div>
                                    @error('valueForMoneyRating')
                                        <span class="text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>

                                <!-- Communication Rating -->
                                <div class="">
                                    <label class="text-black-1200 font-medium text-sm tracking-[-0.096px] leading-5 flex items-center">
                                        {{ __('Communication') }}
                                        <span class="flex items-center ml-1 text-primary-blue">*</span>
                                    </label>
                                    <div x-data="{ hoverRating: 0, rating: @entangle('communicationRating') }">
                                        <ul class="flex gap-2 items-center mt-2">
                                            @for ($i = 1; $i <= 5; $i++)
                                                <li>
                                                    <button type="button" @mouseenter="hoverRating = {{ $i }}" @mouseleave="hoverRating = 0" @click="rating = {{ $i }}; $wire.set('communicationRating', {{ $i }})" class="flex items-center cursor-pointer">
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6 transition-all duration-200" :class="(hoverRating >= {{ $i }} || rating >= {{ $i }}) ? 'text-[#335CFF] fill-current' : 'text-gray-300'" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </button>
                                                </li>
                                            @endfor
                                        </ul>
                                        <p class="mt-2 h-4 text-xs font-semibold leading-4 text-black-1200" :class="(hoverRating > 0 || rating > 0) ? 'visible' : 'invisible'" x-text="hoverRating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][hoverRating - 1] : (rating > 0 ? ['Bad', 'Good', 'Pretty good', 'Excellent', 'Loved it!'][rating - 1] : 'placeholder')">
                                        </p>
                                    </div>
                                    @error('communicationRating')
                                        <span class="text-xs text-red-500">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        <div class="flex justify-between items-end px-6 pb-4 md:pl-4 lg:pr-10 md:pr-4 lg:pb-10 md:mt-6">
                            <div class="relative overflow-hidden md:w-[89px] w-full h-10">
                                <x-frontend.includes.modal-element-loading wire:loading  wire:target="previousStep" />
                                <button
                                    type="button"
                                    wire:click="previousStep"
                                    class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-10 w-full rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors"
                                    wire:loading.attr="disabled"
                                    wire:target="previousStep"
                                >
                                    <span>{{ __('Back') }}</span>
                                </button>
                            </div>
                            <div class="relative overflow-hidden md:w-[89px] w-full h-10 rounded-full">
                                <x-frontend.includes.modal-element-loading wire:loading wire:target="nextStep" />
                                <button
                                    type="button"
                                    wire:click="nextStep"
                                    class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-10 w-full rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors"
                                    wire:loading.attr="disabled"
                                    wire:target="nextStep"
                                >
                                    <span>{{ __('Continue') }}</span>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Step 3: Upload Photos -->
                    <div id="step3" class="step" style="{{ $currentStep === 3 ? 'display: block;' : 'display: none;' }}">
                        <div class="flex gap-4 justify-start items-center px-6 pt-6 pb-3 border-b border-solid md:hidden border-gray-1200">
                            <button type="button" wire:click="previousStep" class="inline-flex justify-center items-center w-10 h-10 rounded-full border border-solid transition-colors cursor-pointer shadow-3xl border-gray-1200 hover:bg-gray-50">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                </svg>
                            </button>
                            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                                {{ __('Upload Photos') }}
                            </h4>
                        </div>
                        <div class="px-6 py-8 lg:pl-5 lg:pr-10 md:px-4 lg:py-10 md:py-5">
                            <div>
                                <h4 class="mb-1 text-xl font-medium leading-7 text-black-1200">
                                    {{ __('Add Photos To Your Review') }}
                                </h4>
                                <p class="text-xs font-medium leading-4 text-mid-gray">
                                    {{ __('Help others see it through your eyes — add photos to your review.') }}
                                </p>
                            </div>
                            <div class="mt-6 md:mt-12">
                                <div x-data="{ isDragging: false }" @dragover.prevent="isDragging = true" @dragleave.prevent="isDragging = false" @drop.prevent="isDragging = false; $refs.fileInput.files = $event.dataTransfer.files; $refs.fileInput.dispatchEvent(new Event('change', { bubbles: true }))" class="p-8 border-2 border-dashed transition-colors duration-200 fileUpload md:px-4 md:py-0" :class="isDragging ? 'border-primary-blue bg-blue-50' : 'border-gray-1600'"
                                    style="border-radius: 12px; height: 206px; display: flex; flex-direction: column; align-items: center; justify-content: center; cursor: pointer;">

                                    <input type="file" x-ref="fileInput" wire:model="photos" multiple accept="image/jpeg,image/jpg,image/png,image/webp" class="hidden">

                                    <label for="file-upload" class="w-full text-center cursor-pointer">
                                        <x-icon-upload-icon-v2 class="mx-auto mb-5" />
                                        <span class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] text-[#525866] block">
                                            {{ __('Choose a File or Drag & Drop It Here.') }}
                                        </span>
                                        <p class="text-sm font-normal leading-5 text-mid-gray text-center tracking-[-0.096px] mt-1.5 mb-5">
                                            {{ __('JPEG, PNG formats, up to 5 MB. Max upload limit of 5 photos') }}
                                        </p>
                                        <button type="button" @click="$refs.fileInput.click()" class="text-mid-gray inline-flex items-center justify-center text-sm font-medium leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full shadow-3xl h-8 px-4 mx-auto hover:bg-gray-50 transition-colors">
                                            {{ __('Upload Photo') }}
                                        </button>
                                        <div wire:loading wire:target="photos" class="flex absolute inset-0 justify-center items-center rounded-md bg-white/80">
                                            <div class="flex flex-col gap-2 items-center">
                                                <div class="w-8 h-8 rounded-full border-b-2 animate-spin border-blue-1200"></div>
                                                <span class="text-xs text-dark-blue">{{ __('Uploading...') }}</span>
                                            </div>
                                        </div>
                                    </label>
                                </div>

                                @error('photos')
                                    <span class="block mt-2 text-xs text-red-500">{{ $message }}</span>
                                @enderror

                                @if (count($uploadedPhotos) > 0)
                                    <div class="mt-6">
                                        <h4 class="text-black-1200 text-sm font-medium leading-5 tracking-[-0.096px]">
                                            {{ __('Uploaded (:count/5)', ['count' => count($uploadedPhotos)]) }}
                                        </h4>
                                        <ul class="flex flex-wrap gap-4 items-center mt-3">
                                            @foreach ($uploadedPhotos as $index => $photo)
                                                <li>
                                                    <span class="relative cursor-pointer group flex items-center flex-col border border-solid border-gray-1200 rounded-2xl w-[121px] h-[121px] overflow-hidden">
                                                        <img src="{{ $photo['temporaryUrl'] }}" alt="{{ __('Photo') }}" class="object-cover object-center w-full h-full" />
                                                        <button type="button" wire:click="removePhoto({{ $index }})" class="absolute top-1/2 left-1/2 p-2 text-white bg-red-500 rounded-full opacity-0 transition-opacity duration-200 -translate-x-1/2 -translate-y-1/2 group-hover:opacity-100 hover:bg-red-600">
                                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                                                            </svg>
                                                        </button>
                                                    </span>
                                                </li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif
                            </div>
                        </div>
                        <div class="flex justify-between items-end px-6 pb-4 md:pl-4 lg:pr-10 md:pr-4 lg:pb-10 md:mt-6">
                            <div class="relative overflow-hidden md:w-[89px] w-full h-10 rounded-full">
                                <x-frontend.includes.modal-element-loading wire:loading wire:target="previousStep" />
                                <button
                                    type="button"
                                    wire:click="previousStep"
                                    class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-10 w-full rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors"
                                    wire:loading.attr="disabled"
                                    wire:target="previousStep"
                                >
                                    <span>{{ __('Back') }}</span>
                                </button>
                            </div>
                            <div class="relative overflow-hidden md:w-[89px] w-full h-10 rounded-full">
                                <x-frontend.includes.modal-element-loading wire:loading wire:target="nextStep" />
                                <button
                                    type="button"
                                    wire:click="nextStep"
                                    class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-10 w-full rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors"
                                    wire:loading.attr="disabled"
                                    wire:target="nextStep"
                                >
                                    <span>{{ __('Continue') }}</span>
                                </button>
                            </div>
                        </div>
                    </div>

                    <!-- Step 4: Summary -->
                    <div id="step4" class="step" style="{{ $currentStep === 4 ? 'display: block;' : 'display: none;' }}">
                        <div class="flex gap-4 justify-start items-center px-6 pt-6 pb-3 border-b border-solid md:hidden border-gray-1200">
                            <button type="button" wire:click="previousStep" class="inline-flex justify-center items-center w-10 h-10 rounded-full border border-solid transition-colors cursor-pointer shadow-3xl border-gray-1200 hover:bg-gray-50">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                                </svg>
                            </button>
                            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                                {{ __('Summary') }}
                            </h4>
                        </div>
                        <div class="px-6 py-8 lg:pl-5 lg:pr-10 md:px-4 lg:py-10 md:py-5">
                            <div class="">
                                <h4 class="mb-1 text-xl font-medium leading-7 text-black-1200">
                                    {{ __('Submit Your Review') }}
                                </h4>
                                <p class="text-xs font-medium leading-4 text-mid-gray">
                                    {{ __('Take a quick look at your review for :member before you hit submit.', ['member' => $member->memberName()]) }}
                                </p>
                            </div>
                            <div class="mt-6 md:mt-8">
                                <div class="">
                                    <!-- Overall Rating -->
                                    <div class="flex flex-col gap-0 justify-between items-start pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                {{ __('Overall Rating') }}
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <ul class="flex gap-2 items-center my-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <li>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 {{ $i <= $overallRating ? 'text-[#335CFF] fill-current' : 'text-gray-300' }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </li>
                                                @endfor
                                            </ul>
                                            <p class="text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($overallRating) }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Review Title -->
                                    @if ($reviewTitle)
                                        <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                            <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                                <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                    {{ __('Review Title') }}
                                                </h4>
                                            </div>
                                            <div class="flex-1 mt-1.5 w-full md:mt-0">
                                                <p class="text-xs font-semibold leading-4 text-mid-gray">
                                                    {{ $reviewTitle }}
                                                </p>
                                            </div>
                                        </div>
                                    @endif

                                    <!-- Review Description -->
                                    <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                {{ __('Review Detail') }}
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <p class="text-sm font-normal leading-5 text-mid-gray">
                                                {{ $reviewDescription }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Service Quality -->
                                    <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                Service Quality
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <ul class="flex gap-2 items-center my-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <li>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 {{ $i <= $serviceQualityRating ? 'text-[#335CFF] fill-current' : 'text-gray-300' }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </li>
                                                @endfor
                                            </ul>
                                            <p class="text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($serviceQualityRating) }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Response Time -->
                                    <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                {{ __('Response Time') }}
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <ul class="flex gap-2 items-center my-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <li>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 {{ $i <= $responseTimeRating ? 'text-[#335CFF] fill-current' : 'text-gray-300' }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </li>
                                                @endfor
                                            </ul>
                                            <p class="text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($responseTimeRating) }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Professionalism -->
                                    <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                {{ __('Professionalism') }}
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <ul class="flex gap-2 items-center my-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <li>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 {{ $i <= $professionalismRating ? 'text-[#335CFF] fill-current' : 'text-gray-300' }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </li>
                                                @endfor
                                            </ul>
                                            <p class="text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($professionalismRating) }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Value for Money -->
                                    <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 border-b border-solid md:gap-6 border-gray-1200 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                {{ __('Value for Money') }}
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <ul class="flex gap-2 items-center my-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <li>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 {{ $i <= $valueForMoneyRating ? 'text-[#335CFF] fill-current' : 'text-gray-300' }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </li>
                                                @endfor
                                            </ul>
                                            <p class="text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($valueForMoneyRating) }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Communication -->
                                    <div class="flex flex-col gap-0 justify-between items-start pt-6 pb-3 {{ count($uploadedPhotos) > 0 ? 'border-b border-solid border-gray-1200' : '' }} md:gap-6 md:flex-row">
                                        <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                            <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                {{ __('Communication') }}
                                            </h4>
                                        </div>
                                        <div class="flex-1 mt-1.5 w-full md:mt-0">
                                            <ul class="flex gap-2 items-center my-2">
                                                @for ($i = 1; $i <= 5; $i++)
                                                    <li>
                                                        <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 {{ $i <= $communicationRating ? 'text-[#335CFF] fill-current' : 'text-gray-300' }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z" />
                                                        </svg>
                                                    </li>
                                                @endfor
                                            </ul>
                                            <p class="text-xs font-semibold leading-4 text-black-1200">
                                                {{ $this->getRatingText($communicationRating) }}
                                            </p>
                                        </div>
                                    </div>

                                    <!-- Images -->
                                    @if (count($uploadedPhotos) > 0)
                                        <div class="flex flex-col gap-0 justify-between items-start pt-6 md:flex-row md:gap-6">
                                            <div class="lg:max-w-[212px] md:max-w-[100px] max-w-full w-full">
                                                <h4 class="text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px]">
                                                    {{ __('Images') }}
                                                </h4>
                                            </div>
                                            <div class="flex-1 mt-1.5 w-full md:mt-0">
                                                <ul class="flex flex-wrap gap-2 items-center">
                                                    @foreach ($uploadedPhotos as $photo)
                                                        <li>
                                                            <img src="{{ $photo['temporaryUrl'] }}" alt="" class="w-[52px] h-[52px] rounded-xl object-cover">
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                            @error('submit')
                                <div class="mt-4 text-sm text-red-500">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="flex justify-between items-end px-6 pb-4 md:pl-4 lg:pr-10 md:pr-4 lg:pb-10 md:mt-6">
                            <div class="relative overflow-hidden md:w-[89px] w-full h-10 rounded-full">
                                <x-frontend.includes.modal-element-loading wire:loading wire:target="previousStep" />
                                <button
                                    type="button"
                                    wire:click="previousStep"
                                    class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-10 w-full rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors"
                                    wire:loading.attr="disabled"
                                    wire:target="previousStep"
                                >
                                    <span>{{ __('Back') }}</span>
                                </button>
                            </div>
                            <button type="submit" wire:loading.attr="disabled" wire:loading.class="opacity-50" class="text-white font-medium text-sm leading-5 tracking-[-0.096px] h-12 md:w-[160px] w-auto px-6 rounded-full bg-black-1200 flex items-center justify-center cursor-pointer hover:bg-black-1300 transition-colors disabled:cursor-not-allowed disabled:opacity-50">
                                <span wire:loading.remove>{{ __('Submit Review') }}</span>
                                <span wire:loading>{{ __('Submitting...') }}</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    @endif
</div>
