<div>
    <div id="styled-Articles"
        role="tabpanel"
        aria-labelledby="Articles-tab">
        <div class="sm:py-12 py-6">
            <div class="flex sm:flex-row flex-col sm:items-center items-start justify-between">
                <h6>{{ __('Latest Articles') }}</h6>
                <form class="relative sm:w-auto w-full sm:mt-0 mt-5">
                    <input type="text"
                        wire:model.live.debounce.500ms="search"
                        class="text-gray-1500 sm:w-auto w-full text-sm font-normal leading-5 tracking-[-0.096px] shadow-3xl pl-10 border border-solid border-gray-1200 rounded-full h-10"
                        placeholder="Search by keyword..." />
                    <span class="flex items-center absolute left-3.5 top-1/2 -translate-y-1/2">
                        <x-icon-search-icon />
                    </span>
                </form>
            </div>
            <div class="pb-12" id="article-list">
                @if ($articles->isNotEmpty())
                    <div class="grid md:grid-cols-2 grid-cols-1 gap-6 mt-5">
                        @foreach ($articles as $article)
                            <x-frontend.articles.article-card :article="$article" :target="'_blank'" />
                        @endforeach
                    </div>
                    @if ($articles->total() > $articles->perPage())
                        <div class="md:mt-8 mt-12">
                            {{ $articles->links('vendor.livewire.esp-sleek-pagination', ['scrollTo' => '#article-list']) }}
                        </div>
                    @endif
                @else
                    <div class="mt-5">

                        <x-frontend.includes.no-records-found-v1>
                            <x-slot:icon>
                                <x-icon-search-icon />
                            </x-slot:icon>
                            <x-slot:title>{{ __('Articles') }}</x-slot:title>
                            <x-slot:description>{{ __('Articles') }}</x-slot:description>
                        </x-frontend.includes.no-records-found-v1>
                    </div>
                @endif
            </div>
            <x-frontend.member.profile.partials.profile-social-media :user="$user" />
        </div>
    </div>
</div>
