<div>
    <div id="styled-Classifields" role="tabpanel" aria-labelledby="Classifields-tab">
        <div class="py-12 border-b border-solid border-gray-1200">
            <div class="flex flex-col justify-between items-start md:flex-row md:items-center">
                <div>
                    <h6>{{ __('Our Latest Classifieds') }}</h6>
                </div>
                <div class="flex gap-3 items-center mt-5 w-full md:w-auto md:mt-0">
                    <form wire:submit.prevent="search" class="relative flex-1 w-full md:flex-initial md:w-auto">
                        <input type="text" wire:model.live.debounce.150ms="search" class="text-gray-1500 xl:w-[250px] md:w-[210px] w-full text-sm font-normal leading-5 tracking-[-0.096px] shadow-3xl pl-10 border border-solid border-gray-1200 rounded-full h-10" placeholder="Search..." />
                        <span class="flex absolute left-3.5 top-1/2 items-center -translate-y-1/2">
                            <x-icon-search-icon />
                        </span>
                    </form>
                    <a href="#" class="hidden filter-btn text-black-1200 font-normal text-sm leading-5 tracking-[-0.096px] bg-white border border-solid border-gray-1200 rounded-full shadow-3xl h-10 cursor-pointer items-center justify-center gap-3 md:w-auto w-10 md:px-[11px] hover:bg-gray-1400 hover:border-gray-1400 hover:text-mid-gray transition-all duration-500 ease-in-out">
                        <x-icon-list-bars />
                        <span class="hidden md:flex">
                            {{ __('Filters') }} (4)
                        </span>
                    </a>
                </div>
            </div>
            <div class="mt-5" id="classified-list">
                @if ($classifieds->isNotEmpty())
                    @foreach ($classifieds as $classified)
                        <x-frontend.classified.classified-card :classified="$classified" :target="'_blank'" />
                    @endforeach
                    @if ($classifieds->total() > $classifieds->perPage())
                        <div class="mt-5">
                            {{ $classifieds->links('vendor.livewire.esp-sleek-pagination', ['scrollTo' => '#classified-list']) }}
                        </div>
                    @endif
                @else
                    <x-frontend.includes.no-records-found-v1>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot:icon>
                        <x-slot:title>{{ __('Classifieds') }}</x-slot:title>
                        <x-slot:description>{{ __('Classifieds') }}</x-slot:description>
                    </x-frontend.includes.no-records-found-v1>
                @endif
            </div>
        </div>
        <x-frontend.member.profile.partials.profile-social-media :user="$user" />
    </div>
</div>
