<div>
    <div id="styled-Jobs" role="tabpanel" aria-labelledby="Jobs-tab">
        <div class="sm:py-12 py-6">
            <div class="flex flex-col justify-between items-start md:flex-row md:items-center">
                <div>
                    <h6>{{ __('Our Latest Jobs') }}</h6>
                </div>
                <div class="flex gap-3 items-center mt-5 w-full md:w-auto md:mt-0">
                    <form wire:submit.prevent="search" class="relative flex-1 w-full md:flex-initial md:w-auto">
                        <input type="text" wire:model.live.debounce.150ms="title" class="text-gray-1500 xl:w-[250px] md:w-[210px] w-full text-sm font-normal leading-5 tracking-[-0.096px] shadow-3xl pl-10 border border-solid border-gray-1200 rounded-full h-10" placeholder="Search..." />
                        <span class="flex absolute left-3.5 top-1/2 items-center -translate-y-1/2">
                            <x-icon-search-icon />
                        </span>
                    </form>
                </div>
            </div>
            @if ($jobs->isNotEmpty())
                <div class="mt-5" id="job-list">
                    @foreach ($jobs as $job)
                        <x-frontend.job.job-card :job="$job" :target="'_blank'" />
                    @endforeach
                </div>
                @if ($jobs->total() > $jobs->perPage())
                    <div class="mt-8">
                        {{ $jobs->links('vendor.livewire.esp-sleek-pagination',['scrollTo' => '#job-list']) }}
                    </div>
                @endif
            @else
                <div class="mt-5">
                    <x-frontend.includes.no-records-found-v1>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot:icon>
                        <x-slot:title>{{ __('Jobs') }}</x-slot:title>
                        <x-slot:description>{{ __('Jobs') }}</x-slot:description>
                    </x-frontend.includes.no-records-found-v1>
                </div>
            @endif
        </div>


    </div>
</div>
