<div>
    <div class="flex items-center justify-between">
        <h6>{{ __('Our Latest Job Listings') }}</h6>
        <a href="#" class="text-mid-gray hover:text-black-1200 w-[81px] font-medium text-sm leading-5 tracking-[-0.096px] flex items-center justify-center bg-gray-1400 hover:bg-white border border-solid border-gray-1400 hover:border-gray-1200 transition-all duration-500 ease-in-out rounded-full h-10">
            {{ __('View All') }}
        </a>
    </div>
    <div>
        @if ($latestJobs->isNotEmpty())
            @foreach ($latestJobs as $job)
                <x-frontend.team.latest-job-card :job="$job" />
            @endforeach
        @else
            <div class="mt-8">
                <x-frontend.includes.no-records-found-v1>
                    <x-slot:title>{{ __('No Latest Jobs found') }}</x-slot:title>
                    <x-slot:description>{{ __('No Latest Jobs found') }}</x-slot:description>
                </x-frontend.includes.no-records-found-v1>
            </div>
        @endif
    </div>
</div>
