<div>
    <div id="styled-Projects" role="tabpanel" aria-labelledby="Projects-tab">
        <div class="sm:py-12 py-6" id="project-list">
            <h6>{{ __('Our Latest Projects') }}</h6>
            @if ($projects->isNotEmpty())
                <div class="grid md:grid-cols-2 grid-cols-1 gap-6 mt-5">
                    @foreach ($projects as $project)
                        <x-frontend.project.project-card :project="$project" :target="'_blank'" />
                    @endforeach
                </div>
                @if ($projects->total() > $projects->perPage())
                    <div class="mt-8">
                        {{ $projects->links('vendor.livewire.esp-sleek-pagination',['scrollTo' => '#project-list']) }}
                    </div>
                @endif
            @else
                <div class="grid md:grid-cols-2 grid-cols-1 gap-6 mt-5">
                    <x-frontend.includes.no-records-found-v1>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot:icon>
                        <x-slot:title>{{ __('Projects') }}</x-slot:title>
                        <x-slot:description>{{ __('Projects') }}</x-slot:description>
                    </x-frontend.includes.no-records-found-v1>
                </div>
            @endif

        </div>

        <x-frontend.member.profile.partials.profile-social-media :user="$user" />

    </div>
</div>
