@props(['reviewsStats' => []])
@php
    $average_rating = $reviewsStats['average_rating'] ?? null;
    $rating_count = $reviewsStats['total_reviews'] ?? 0;
    $ratings = [];
    $total = 0;
    if (isset($reviewsStats['rating_distribution'])) {
        foreach ($reviewsStats['rating_distribution'] as $rating => $data) {
            $ratings[$rating] = $data['count'];
            $total += $data['count'];
        }
    } else {
        $ratings = [
            5 => 0,
            4 => 0,
            3 => 0,
            2 => 0,
            1 => 0,
        ];
    }
    $ratingTypes = [
        'service_quality' => [
            'icon' => 'icon-favourite-circle',
            'label' => __('Service Quality'),
        ],
        'response_time' => [
            'icon' => 'icon-clock-countdown',
            'label' => __('Response Time'),
        ],
        'professionalism' => [
            'icon' => 'icon-suit',
            'label' => __('Professionalism'),
        ],
        'value_for_money' => [
            'icon' => 'icon-money',
            'label' => __('Value for Money'),
        ],
        'communication' => [
            'icon' => 'icon-message-multiple',
            'label' => __('Communication'),
        ],
    ];
@endphp
<div>
    <div id="styled-Reviews"
        role="tabpanel"
        aria-labelledby="Reviews-tab">
        <div class="pt-6 pb-6 border-solid sm:pt-6 sm:pb-12 sm:border-b border-gray-1200">
            <div class="flex justify-between items-center">
                <h6>{{ __('Reviews') }}</h6>
                <div class="overflow-hidden relative text-mid-gray hover:text-black-1200 w-[146px] font-medium text-sm leading-5 tracking-[-0.096px] flex items-center justify-center gap-2.5 bg-gray-1400 hover:bg-white border border-solid border-gray-1400 hover:border-gray-1200 transition-all duration-500 ease-in-out rounded-full h-9 cursor-pointer" x-on:click="Livewire.dispatch('openModal', { component: 'frontend.member.modal.review-write-modal', arguments: { member: '{{ $user->slug }}' }})">
                    <x-frontend.includes.modal-element-loading class="write-review-btn-overlay-{{ $user->slug }}" />
                    <div class="flex gap-2.5 items-center">
                        <x-icon-pencil />
                        {{ __('Write a Review') }}
                    </div>
                </div>
            </div>
            <div class="flex gap-6 items-center mt-5 sm:gap-8">
                <div class="sm:max-w-[238px] max-w-[159px] w-full">
                    <h4 class="font-semibold md:text-[56px] text-5xl leading-16 text-black-1200">
                        {{ $average_rating }}
                    </h4>
                    <div class="flex gap-1.5 items-center my-3">
                        <x-frontend.review.partials.review-average-star-yellow :rating="$reviewsStats['average_rating'] ?? 4.91" color="black" />
                    </div>
                    <p class="sm:text-base text-sm font-medium leading-6 tracking-[-0.176px] text-mid-gray">
                        {{ __('Based on') }} {{ $rating_count }} {{ __('reviews') }}
                    </p>
                </div>

                <div class="flex-1 w-full">
                    @for ($i = 5; $i >= 1; $i--)
                        <div class="flex gap-2 items-center mb-1.5">
                            <span class="text-sm font-medium leading-5 tracking-[-0.096px] flex items-center justify-center w-5 h-5">{{ $i }}</span>
                            <div class="flex-1 w-full h-1.5 rounded-full bg-gray-1200">
                                <div class="h-1.5 rounded-full bg-black-1300" style="width: {{ $total > 0 ? round((($ratings[$i] ?? 0) / $total) * 100) : 0 }}%"></div>
                            </div>
                        </div>
                    @endfor
                </div>

            </div>
            <div class="grid grid-cols-2 gap-6 mt-12 mb-6 lg:grid-cols-5 sm:grid-cols-3 2xl:gap-6 lg:gap-0 sm:gap-4">
                @foreach ($ratingTypes as $type => $config)
                    <div class="px-4 xl:px-4 md:px-2.5">
                        <span class="flex items-center">
                            <x-dynamic-component :component="$config['icon']" />
                        </span>
                        <p class="text-mid-gray xl:text-sm text-xs mt-6 font-medium leading-6 tracking-[-0.096px]">
                            {{ $config['label'] }}
                        </p>
                        <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px]">
                            {{ number_format($reviewsStats['rating_types'][$type]['average'] ?? 0, 1) }}%
                        </h4>
                    </div>
                @endforeach
            </div>
            <a href="javascript:void(0)" onclick="document.getElementById('profile-reviews-styled-tab').click()" class="text-mid-gray hover:text-black-1200 w-[161px] font-medium text-sm leading-5 tracking-[-0.096px] sm:hidden flex items-center justify-center gap-2.5 bg-gray-1400 hover:bg-white border border-solid border-gray-1400 hover:border-gray-1200 transition-all duration-500 ease-in-out rounded-full h-9">
                {{ __('Read all') }} {{ count($reviews) }} {{ __('reviews') }}
            </a>
        </div>
        <div id="review-list">
            {{-- <div x-show="reviewsTabLoading" class="absolute inset-0 z-50 w-full h-full bg-white backdrop-blur-sm">
                <x-frontend.includes.loading-overlay-list :rows="6" layout="review-list" class="mt-4" />
            </div> --}}
            @if ($reviews->isNotEmpty())
                @foreach ($reviews as $review)
                    <x-frontend.review.testimonial-card :review="$review" />
                @endforeach
                @if ($reviews->total() > $reviews->perPage())
                    <div class="mt-6">
                        {{ $reviews->links('vendor.livewire.esp-sleek-pagination', ['scrollTo' => '#review-list']) }}
                    </div>
                @endif
            @else
                <x-frontend.includes.no-records-found-v1>
                    <x-slot:title>{{ __('Reviews') }}</x-slot:title>
                </x-frontend.includes.no-records-found-v1>
            @endif

        </div>
    </div>
</div>
