<div>
    <div id="styled-Services"
        role="tabpanel"
        aria-labelledby="Services-tab">
        @if ($services->isNotEmpty())
            <div class="py-12 border-b border-solid border-gray-1200">
                <h6>{{ $user->memberName() }} {{ __('Services') }}</h6>
                @foreach ($services as $service)
                    <div class="mt-5">
                        <div class="flex gap-3 items-start p-4 mb-4 bg-white rounded-2xl border border-solid border-gray-1200">
                            <span class="flex justify-center items-center w-10 h-10">
                                <x-icon-check-icon />
                            </span>
                            <div class="flex-1 w-full">
                                <h4 class="font-medium xl:text-base sm:text-sm text-base leading-6 tracking-[-0.176px] text-black-1200">
                                    {{ $service->service_title }}
                                </h4>
                                <p class="mt-1.5 w-full text-base font-normal leading-6 text-mid-gray xl:text-base sm:text-sm">
                                    {{ str()->limit($service->service_description, 200) }}
                                </p>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @endif
        @if ($user->getWhyChooseUs())
            <div class="py-12 border-b border-solid border-gray-1200">
                <h6>{{ __('Why Choose') }} {{ $user->memberName() }}</h6>
                <div class="grid grid-cols-1 gap-4 mt-5 md:grid-cols-2">
                    @foreach ($user->getWhyChooseUs() as $whyChooseUs)
                        <div class="flex gap-3 items-start p-4 rounded-2xl bg-gray-1400">
                            <span class="flex justify-center items-center w-10 h-10">
                                <x-icon-check-icon />
                            </span>
                            <div class="flex-1 w-full">
                                <h5 class="font-medium xl:text-base sm:text-sm text-base leading-6 tracking-[-0.176px] text-black-1200">
                                    {{ $whyChooseUs['title'] }}
                                </h5>
                                <p class="flex items-center mt-1.5 text-base font-normal leading-6 xl:text-base sm:text-sm text-mid-gray">
                                    {{ str()->limit($whyChooseUs['value'], 200) }}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
        @if ($user->getOurSupportServices())
            <div class="py-12 border-b border-solid border-gray-1200">
                <h6>{{ __('Our Support Services') }}</h6>
                <ul class="flex flex-wrap gap-2 items-center mt-5">
                    @foreach ($user->getOurSupportServices() as $supportService)
                        <li><a href="#" class="tags !border-0">{{ $supportService }}</a></li>
                    @endforeach
                </ul>
            </div>
        @endif
        <x-frontend.member.profile.partials.profile-social-media :user="$user" />
    </div>

</div>
