<div>
    <div id="styled-Team"
        role="tabpanel"
        aria-labelledby="Team-tab">
        <div class="pt-12" id="team-list">
            <h6>{{ __('Our Team') }}</h6>
            @if ($teamMembers->isNotEmpty())
                <div class="grid grid-cols-1 gap-6 mt-5 md:grid-cols-2">
                    @foreach ($teamMembers as $team)
                        <x-frontend.team.team-card :team="$team" />
                    @endforeach
                </div>
                <div class="pb-12 mt-8">
                    @if ($teamMembers->total() > $teamMembers->perPage())
                        {{ $teamMembers->links('vendor.livewire.esp-sleek-pagination', ['scrollTo' => '#team-list']) }}
                    @endif
                </div>
            @else
                <div class="pb-12 mt-8">
                    <x-frontend.includes.no-records-found-v1>
                        <x-slot:icon>
                            <x-icon-search-icon />
                        </x-slot:icon>
                        <x-slot:title>{{ __('Team Members') }}</x-slot:title>
                        <x-slot:description>{{ __('Team Members') }}</x-slot:description>
                    </x-frontend.includes.no-records-found-v1>
                </div>
            @endif

            <div class="pt-12 border-t border-solid border-gray-1200">
                <livewire:frontend.member.profile-tabs.partials.team-member-latest-jobs :userId="$userId" lazy />
            </div>
        </div>
    </div>
</div>
