<div>
    <div id="styled-Video" role="tabpanel" aria-labelledby="Video-tab">
        <div class="pt-12" >
            <div class="flex md:flex-row flex-col md:items-center items-start justify-between">
                <h6>{{ __('Our Latest Videos') }}</h6>
                <div class="flex items-center gap-3 md:w-auto w-full md:mt-0 mt-5">
                    <form class="relative md:flex-initial flex-1 md:w-auto w-full">
                        <input type="text" wire:model.live.debounce.500ms="search" class="text-gray-1500 xl:w-[250px] md:w-[210px] w-full text-sm font-normal leading-5 tracking-[-0.096px] shadow-3xl pl-10 border border-solid border-gray-1200 rounded-full h-10" placeholder="Search..." />
                        <span class="flex items-center absolute left-3.5 top-1/2 -translate-y-1/2">
                            <x-icon-search-icon />
                        </span>
                    </form>
                    <a href="#" class="hidden filter-btn text-black-1200 font-normal text-sm leading-5 tracking-[-0.096px] bg-white border border-solid border-gray-1200 rounded-full shadow-3xl h-10 cursor-pointer items-center justify-center gap-3 md:w-auto w-10 md:px-[11px] hover:bg-gray-1400 hover:border-gray-1400 hover:text-mid-gray transition-all duration-500 ease-in-out">
                        <x-icon-list-bars />
                        <span class="md:flex hidden">
                            {{ __('Filters') }}
                        </span>
                    </a>
                </div>
            </div>
            <div>
                <div class="pb-12 mt-6" id="video-list">
                    @if ($videos->isNotEmpty())
                        <div class="grid md:grid-cols-2 grid-cols-1 gap-6">
                            @foreach ($videos as $video)
                                <x-frontend.videos.video-card :video="$video" />
                            @endforeach
                        </div>
                        @if ($videos->total() > $videos->perPage())
                            <div class="md:mt-8 mt-12">
                                {{ $videos->links('vendor.livewire.esp-sleek-pagination',['scrollTo' => '#video-list']) }}
                            </div>
                        @endif
                    @else
                        <x-frontend.includes.no-records-found-v1>
                            <x-slot:icon>
                                <x-icon-search-icon />
                            </x-slot:icon>
                            <x-slot:title>{{ __('Videos') }}</x-slot:title>
                            <x-slot:description>{{ __('Videos') }}</x-slot:description>
                        </x-frontend.includes.no-records-found-v1>
                    @endif
                </div>
                <x-frontend.includes.social-profiles :user="$user" />
            </div>
        </div>
    </div>
</div>
