<div x-data
    x-init="$watch('open', value => {
        if (!value) {
            document.body.style.overflow = '';
        } else {
            document.body.style.overflow = 'hidden';
        }
    })"
    class="overflow-y-auto relative bg-white rounded-3xl md:my-0 sm:my-20">
    <!-- Main modal -->

    <div class="relative md:p-4 w-full max-w-[880px] max-h-full">
        <!-- Modal content -->
        <div class="relative bg-white md:rounded-3xl">
            <a href="javascript::void(0)"
                onclick="Livewire.dispatch('closeModal')"
                class="hidden absolute top-6 right-6 justify-center items-center w-6 h-6 sm:flex md:right-4 md:top-4">
                <svg width="10"
                    height="10"
                    viewBox="0 0 10 10"
                    fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path d="M5.00005 3.93949L8.71255 0.22699L9.77305 1.28749L6.06055 4.99999L9.77305 8.71249L8.71255 9.77299L5.00005 6.06049L1.28755 9.77299L0.227051 8.71249L3.93955 4.99999L0.227051 1.28749L1.28755 0.22699L5.00005 3.93949Z" fill="#525866" />
                </svg>
            </a>

            <!-- Modal body -->
            <div class="md:p-10 sm:p-6">
                <div class="flex flex-col items-start sm:flex-row sm:items-center sm:gap-6">
                    <div class="flex gap-3 items-center p-6 w-full border-b border-solid sm:w-auto sm:border-b-0 border-gray-1200 sm:p-0">
                        <a href="#"
                            data-modal-hide="default-modal2"
                            class="flex justify-center items-center w-6 h-6 sm:hidden"><img src="images/left-arrow.svg" alt="" /></a>
                        <div class="sm:w-[128px] w-10 sm:h-[128px] h-10 border border-solid border-gray-1200 sm:rounded-xl rounded-full flex items-center flex-col">
                            @if ($teamMember->getFirstMediaUrl('featured_image'))
                                <img src="{{ $teamMember->getFirstMediaUrl('featured_image', 'thumb') }}"
                                    alt="{{ $teamMember->full_name }}"
                                    class="object-cover w-full h-full rounded-full sm:rounded-xl" />
                            @else
                                <img src="/images/image_placeholder.webp"
                                    alt="{{ $teamMember->full_name }}"
                                    class="object-cover w-full h-full rounded-full sm:rounded-xl" />
                            @endif
                        </div>
                        <h5 class="text-lg sm:hidden block text-black-1200 font-medium leading-6 tracking-[-0.24px]">{{ $teamMember->full_name }}</h5>
                    </div>
                    <div class="flex-1 px-6 pt-8 pb-0 w-full sm:px-0 sm:py-0">
                        <h5 class="hidden mb-3 text-2xl font-medium leading-8 sm:block text-black-1200">{{ $teamMember->full_name }}</h5>
                        <ul class="flex gap-2 items-center mb-3">
                            @if ($teamMember->team_member_role)
                                <li><a href="#" class="tags">{{ $teamMember->team_member_role }}</a></li>
                            @endif
                            @if ($teamMember->experience_years)
                                <li><a href="#" class="tags">{{ $teamMember->experience_years }} Years of Experience</a></li>
                            @endif
                        </ul>
                        @if ($teamMember->user)
                            <div class="flex gap-3 items-center">
                                <div class="flex relative justify-center items-center p-1 w-10 h-10 rounded-2xl border border-solid border-gray-1200 sm:p-2.5 sm:w-12 sm:h-12">
                                    @if ($teamMember->user->logoImage())
                                        <img src="{{ $teamMember->user->logoImage() }}"
                                            alt="{{ $teamMember->user->memberName() }}"
                                            class="object-cover w-full h-full rounded-lg">
                                    @endif
                                </div>
                                <h5 class="flex-1 w-full sm:text-lg text-base text-black-1200 font-medium leading-6 sm:tracking-[-0.24px] tracking-[-0.176px]">
                                    {{ $teamMember->user->memberName() }}</h5>
                            </div>
                        @endif
                    </div>
                </div>
                @if ($teamMember->description)
                    <div class="px-6 mt-6 sm:px-0">
                        <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">About</h4>
                        <div class="mt-3 text-base font-normal leading-6 text-mid-gray">
                            {!! $teamMember->description !!}
                        </div>
                    </div>
                @endif
                @if ($teamMember->phone || $teamMember->email)
                    <div class="px-6 mt-6 sm:mt-12 sm:px-0">
                        <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">Contact Information
                        </h4>
                        <div class="grid grid-cols-1 gap-4 mt-5 md:grid-cols-2">
                            @if ($teamMember->phone)
                                <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                                    <span class="flex justify-center items-center w-10 h-10">
                                        <x-icon-phone-black />
                                    </span>
                                    <div class="flex-1 w-full">
                                        <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">Phone</span>
                                        <a href="tel:{{ $teamMember->phone }}" class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">{{ $teamMember->phone }}</a>
                                    </div>
                                </div>
                            @endif
                            @if ($teamMember->email)
                                <div class="flex gap-1.5 items-center p-4 rounded-2xl border border-solid border-gray-1200">
                                    <span class="flex justify-center items-center w-10 h-10">
                                        <x-icon-email-icon />
                                    </span>
                                    <div class="flex-1 w-full">
                                        <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">Email</span>
                                        <a href="mailto:{{ $teamMember->email }}" class="flex items-center font-medium text-base tracking-[-0.176px] leading-6 text-black-1200 mt-1.5">{{ $teamMember->email }}</a>
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                @endif
                @if ($teamMember->credentials && is_array($teamMember->credentials) && count($teamMember->credentials) > 0)
                    <div class="px-6 mt-6 sm:mt-12 sm:px-0">
                        <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">Qualifications &
                            {{ __('Certifications') }}
                        </h4>
                        <div class="grid grid-cols-1 gap-4 mt-5 lg:grid-cols-3 sm:grid-cols-2">
                            @foreach ($teamMember->credentials as $credential)
                                @if (isset($credential['title']) && isset($credential['description']))
                                    <div class="flex gap-1.5 items-center p-4 rounded-2xl bg-gray-1400">
                                        <span class="flex justify-center items-center w-10 h-10">
                                            <x-icon-trophy-line />
                                        </span>
                                        <div class="flex-1 w-full">
                                            <span class="flex items-center font-medium text-sm tracking-[-0.096px] leading-5 text-mid-gray">{{ $credential['description'] }}</span>
                                            <p class="flex items-center font-medium text-sm tracking-[-0.096px] leading-6 text-black-1200">
                                                {{ $credential['title'] }}</p>
                                        </div>
                                    </div>
                                @endif
                            @endforeach
                        </div>
                    </div>
                @endif

                @if ($teamMember->social_links && is_array($teamMember->social_links) && count(array_filter($teamMember->social_links)) > 0)
                    <div class="px-6 mt-6 sm:mt-12 sm:px-0">
                        <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px]">Social Media</h4>
                        <div class="flex gap-3 items-center mt-4">
                            @if (!empty($teamMember->social_links['facebook']))
                                <a href="{{ $teamMember->social_links['facebook'] }}"
                                    target="_blank"
                                    class="flex justify-center items-center w-10 h-10 rounded-lg transition-colors duration-200 bg-gray-1400 hover:bg-primary-blue">
                                    <x-icon-facebook-outline class="h-5" />
                                </a>
                            @endif
                            @if (!empty($teamMember->social_links['linkedin']))
                                <a href="{{ $teamMember->social_links['linkedin'] }}"
                                    target="_blank"
                                    class="flex justify-center items-center w-10 h-10 rounded-lg transition-colors duration-200 bg-gray-1400 hover:bg-primary-blue">
                                    <x-icon-linked-outline class="h-5" />
                                </a>
                            @endif
                            @if (!empty($teamMember->social_links['youtube']))
                                <a href="{{ $teamMember->social_links['youtube'] }}"
                                    target="_blank"
                                    class="flex justify-center items-center w-10 h-10 rounded-lg transition-colors duration-200 bg-gray-1400 hover:bg-primary-blue">
                                    <x-icon-youtube class="h-5" />
                                </a>
                            @endif
                            @if (!empty($teamMember->social_links['instagram']))
                                <a href="{{ $teamMember->social_links['instagram'] }}"
                                    target="_blank"
                                    class="flex justify-center items-center w-10 h-10 rounded-lg transition-colors duration-200 bg-gray-1400 hover:bg-primary-blue">
                                    <x-icon-instagram-outline class="h-5" />
                                </a>
                            @endif
                            @if (!empty($teamMember->social_links['x']))
                                <a href="{{ $teamMember->social_links['x'] }}"
                                    target="_blank"
                                    class="flex justify-center items-center w-10 h-10 rounded-lg transition-colors duration-200 bg-gray-1400 hover:bg-primary-blue">
                                    <x-icon-twitter-outline class="h-5" />
                                </a>
                            @endif
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
