<section class="py-12 md:py-20">
    <div class="max-w-[1232px] w-full  mx-auto  md:px-4 px-0">
        @if ($classifieds->isNotEmpty())
            <div class="flex flex-col justify-between items-start px-6 lg:flex-row md:px-0">
                <div class="mb-0 md:mb-8 lg:mb-0">
                    <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-[32px] text-black-1200 font-normal  lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.32px] tracking-[-0.64px]">
                        {!! $heading !!}
                    </h3>
                    @if (!empty($description))
                        <div class="text-mid-gray font-normal md:text-lg text-base leading-6 tracking-[-0.24px] md:mt-2 mt-1.5">
                            {!! $description !!}
                        </div>
                    @endif
                </div>
                <ul class="hidden gap-4 items-center md:flex">
                    <li>
                        <a href="{{ route('dashboard.classified.add') }}" class="cursor-pointer text-[19.6px] font-bold leading-7 tracking-[-0.118px] text-black rounded-full btn-gradient transition-all duration-500 ease-in-out h-14 px-[29.6px] shadow-24xl flex items-center justify-center">
                            {{ __('List an item') }}
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('classified.index') }}" class="cursor-pointer text-[19.6px] font-medium leading-7 tracking-[-0.118px] shadow-25xl text-mid-gray rounded-full bg-white hover:bg-gray-1400 hover:border-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out border border-solid border-gray-1200 h-14 px-[19.6px] flex items-center justify-center">
                            {{ __('View all') }}
                        </a>
                    </li>
                </ul>
            </div>
            <div class="mt-0 mb-0 md:mt-10">
                <div class="swiper homeClassifiedsSwiper md:!px-0 !py-6 !px-6">
                    <div class="swiper-wrapper">
                        @foreach ($classifieds as $classified)
                            <div class="swiper-slide">
                                @include('components.frontend.classified.classified-card-v2', ['classified' => $classified, 'target' => '_self'])
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <ul class="flex flex-col gap-4 items-center px-6 w-full md:hidden">
                <li class="w-full">
                    <a href="{{ route('dashboard.classified.add') }}" class="cursor-pointer text-[19.6px] font-bold leading-7 tracking-[-0.118px] text-black rounded-full btn-gradient transition-all duration-500 ease-in-out h-14 px-[29.6px] shadow-24xl flex items-center justify-center">
                        {{ __('List an item') }}
                    </a>
                </li>
                <li class="w-full">
                    <a href="{{ route('classified.index') }}" class="cursor-pointer text-[19.6px] font-medium leading-7 tracking-[-0.118px] shadow-25xl text-mid-gray rounded-full bg-white hover:bg-gray-1400 hover:border-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out border border-solid border-gray-1200 h-14 px-[19.6px] flex items-center justify-center">
                        {{ __('View all') }}
                    </a>
                </li>
            </ul>
    </div>
    @endif
    </div>
