<div class="p-3 bg-white">
    <div class="py-6 rounded-3xl bg-gray-1800 md:py-20">
        <div class="max-w-[1232px] w-full  mx-auto md:px-4 px-0">
            <div class="flex flex-col justify-between items-start lg:flex-row">
                <div class="px-6 mb-0 md:px-0">
                    <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-[32px]  text-black-1200 font-normal  lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.32px] tracking-[-0.64px]">
                        {!! $heading !!}
                    </h3>
                    @if (!empty($description))
                        <div class="text-mid-gray font-normal md:text-lg text-base leading-6 tracking-[-0.24px] md:mt-2 mt-1">
                            {!! $description !!}
                        </div>
                    @endif
                </div>
                <ul class="hidden gap-4 items-center md:flex">
                    <li>
                        <a href="{{ route('dashboard.job.add') }}" class="cursor-pointer text-[19.6px] font-bold leading-7 tracking-[-0.118px] text-black rounded-full btn-gradient transition-all duration-500 ease-in-out h-14 px-[34px] shadow-24xl flex items-center justify-center">
                            {{ __('List a job') }}
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('job.index') }}" class="cursor-pointer text-[19.6px] font-medium leading-7 tracking-[-0.118px] shadow-25xl text-mid-gray rounded-full bg-white hover:bg-gray-1400 hover:border-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out border border-solid border-gray-1200 h-14 px-[19.6px] flex items-center justify-center">
                            {{ __('View all Jobs') }}
                        </a>
                    </li>
                </ul>
            </div>
            <div class="hidden grid-cols-1 gap-6 mt-16 md:grid lg:grid-cols-3 md:grid-cols-2">
                @foreach ($jobs as $job)
                    <x-frontend.job.job-card-v2 :job="$job" />
                @endforeach
            </div>
            <div class="block md:hidden">
                <div class="swiper homeJobSwiper !px-6 !pt-6 !pb-[120px]">
                    <div class="swiper-wrapper">
                        @foreach ($jobs as $job)
                            <div class="swiper-slide"> <x-frontend.job.job-card-v2 :job="$job" /></div>
                        @endforeach
                    </div>
                </div>
            </div>
            <ul class="md:hidden flex flex-col gap-6 items-center w-full px-6 -mt-[96px] relative z-10">
                <li class="w-full">
                    <a href="{{ route('dashboard.job.add') }}" class="cursor-pointer text-[19.6px] font-bold leading-7 tracking-[-0.118px] text-black md:w-auto w-full rounded-full btn-gradient transition-all duration-500 ease-in-out h-14 px-6 shadow-24xl flex items-center justify-center">
                        {{ __('List a new job') }}
                    </a>
                </li>
                <li class="w-full">
                    <a href="{{ route('job.index') }}" class="cursor-pointer text-[19.6px] font-medium leading-7 tracking-[-0.118px] shadow-25xl text-mid-gray rounded-full bg-white hover:bg-gray-1400 hover:border-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out border border-solid border-gray-1200 h-14 px-[19.6px] flex items-center justify-center">
                        {{ __('View all') }}
                    </a>
                </li>
            </ul>
        </div>
    </div>
</div>
