<div>
    <div class="py-12 bg-gray-1400 md:rounded-3xl md:py-20">
        <div class="max-w-[1288px] w-full mx-auto md:px-4 px-5">
            <div class="md:text-center text-left md:mb-[64px] mb-12 md:px-0 px-[5px]">
                <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-5xl text-black-1200 font-normal lg:leading-[56px] md:leading-[48px] leading-[56px] md:tracking-[-0.32px] tracking-[-0.96px]">
                    {!! $heading !!}
                </h3>
                @if (!empty($content))
                    <div class="text-mid-gray font-medium text-lg leading-6 md:tracking-[-0.24px] tracking-[-0.27px] mt-1.5">
                        {!! $content !!}
                    </div>
                @endif
            </div>
            <form wire:submit.prevent="submit">
                {{-- Hidden fields for location data --}}
                <input type="hidden" wire:model="address" />
                <input type="hidden" wire:model="lat" />
                <input type="hidden" wire:model="lng" />
                <input type="hidden" wire:model="city" />
                <input type="hidden" wire:model="state" />
                <input type="hidden" wire:model="state_code" />
                <input type="hidden" wire:model="country" />
                <input type="hidden" wire:model="country_code" />

                <div>
                    <div class="overflow-x-auto -mx-5 md:mx-0">
                        <ol class="flex gap-3 justify-start items-center px-6 whitespace-nowrap md:justify-center md:px-0 info-steps">
                            <li>
                                <a href="javascript:void(0)"
                                    class="step-link rounded-lg w-full flex items-center gap-2"
                                    data-step="1">
                                    <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 bg-white rounded-full border border-solid number-box border-gray-1200 text-mid-gray">
                                        <span class="step-number">{{ __('1') }}</span>
                                        <span class="hidden text-white step-check">
                                            <x-icon-check-complete />
                                        </span>
                                    </span>
                                    <p class="flex flex-1 justify-between items-center w-full text-base font-normal leading-6 text-mid-gray">
                                        {{ __('Contact Info') }}
                                    </p>
                                </a>
                            </li>
                            <li><span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-right-arrow3 />
                                </span></li>
                            <li>
                                <a href="javascript:void(0)"
                                    class="step-link rounded-lg w-full  flex items-center gap-2"
                                    data-step="2">
                                    <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 bg-white rounded-full border border-solid number-box border-gray-1200 text-mid-gray">
                                        <span class="step-number">{{ __('2') }}</span>
                                        <span class="hidden text-white step-check">
                                            <x-icon-check-complete />
                                        </span>
                                    </span>
                                    <p class="flex flex-1 justify-between items-center w-full text-base font-normal leading-6 text-mid-gray">
                                        {{ __('Well Drilling Details') }}
                                    </p>
                                </a>
                            </li>
                            <li><span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-right-arrow3 />
                                </span>
                            </li>
                            <li>
                                <a href="javascript:void(0)"
                                    class="step-link rounded-lg w-full  flex items-center gap-2"
                                    data-step="3">
                                    <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 bg-white rounded-full border border-solid number-box border-gray-1200 text-mid-gray">
                                        <span class="step-number">{{ __('3') }}</span>
                                        <span class="hidden text-white step-check">
                                            <x-icon-check-complete />
                                        </span>
                                    </span>
                                    <p class="flex flex-1 justify-between items-center w-full text-base font-normal leading-6 text-mid-gray">
                                        {{ __('Property & Timeline') }}
                                    </p>
                                </a>
                            </li>
                            <li>
                                <span class="flex justify-center items-center w-5 h-5">
                                    <x-icon-right-arrow3 />
                                </span>
                            </li>
                            <li>
                                <a href="javascript:void(0)"
                                    class="step-link rounded-lg w-full  flex items-center gap-2"
                                    data-step="4">
                                    <span class="flex justify-center items-center w-5 h-5 text-xs font-medium leading-4 bg-white rounded-full border border-solid number-box border-gray-1200 text-mid-gray">
                                        <span class="step-number">{{ __('4') }}</span>
                                    </span>
                                    <p class="flex flex-1 justify-between items-center w-full text-base font-normal leading-6 text-mid-gray">
                                        {{ __('Complete Your System') }}
                                    </p>
                                </a>
                            </li>
                        </ol>
                    </div>
                    <div class="max-w-[740px] w-full mx-auto md:mt-12 mt-9">
                        <div class="lead-wizard-form" data-current-step="{{ $this->currentStep ?? 0 }}">
                            <div id="step1" class="step">
                                <div class="bg-white border-[12px] shadow-19xl border-solid border-blue-1900/[0.5] rounded-[22px] md:p-8 p-6">
                                    <div class="flex flex-col gap-4 items-start mb-8 sm:flex-row sm:items-center">
                                        <span class="border border-solid border-blue-2000 rounded-[14px] w-[52px] h-[52px] flex items-center justify-center gradient shadow-16xl">
                                            <x-icon-user-icon />
                                        </span>
                                        <div class="flex-1 w-full">
                                            <h5 class="mb-1 text-2xl font-medium leading-6 text-black-1200 sm:leading-8 lg:text-2xl md:text-xl">
                                                {{ __('Your Contact Information') }}
                                            </h5>
                                            <p class="text-base font-normal leading-6 text-mid-gray lg:text-base md:text-sm lg::leading-6 md:leading-5">
                                                {{ __('Please provide the best way for our office to reach you.') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 sm:gap-5">
                                        <div>
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('First name') }}
                                                <span class="text-primary-blue">{{ __('*') }}</span>
                                                </span>
                                            </label>
                                            <input type="text"
                                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="{{ __('e.g John') }}"
                                                wire:model="firstName" />
                                            @error('firstName')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div>
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('Last name') }}
                                                <span class="text-primary-blue">{{ __('*') }}</span>
                                                </span>
                                            </label>
                                            <input type="text"
                                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="{{ __('e.g Doe') }}"
                                                wire:model="lastName" />
                                            @error('lastName')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div>
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('Phone number') }}
                                                <span class="text-primary-blue">{{ __('*') }}</span>
                                            </label>
                                            <input type="tel"
                                                class="phone border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="{{ __('(555) 000-0000') }}"
                                                wire:model="phoneNumber" />
                                            @error('phoneNumber')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div>
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('Email') }}
                                                <span class="text-primary-blue">{{ __('*') }}</span>
                                            </label>
                                            <input type="text"
                                                class="border border-solid border-gray-1200 rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="{{ __('hello@eps.com') }}"
                                                wire:model="emailAddress" />
                                            @error('emailAddress')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="mt-5">
                                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                            {{ __('Your Relationship to the Property') }}
                                            <span class="text-primary-blue">{{ __('*') }}</span>
                                            </span>
                                        </label>
                                        <div class="relative mt-1">
                                            <select wire:model="propertyRelationship" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                <option value="">{{ __('Select your relationship') }}</option>
                                                @foreach ($propertyRelationshipList as $relationship)
                                                    <option value="{{ $relationship->value }}">{{ $relationship->getLabel() }}</option>
                                                @endforeach
                                            </select>
                                            <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2 text-[#99A0AE]">
                                                <x-icon-down-arrow2 />
                                            </span>
                                        </div>
                                        @error('propertyRelationship')
                                            <span class="text-red-500">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="mt-5">
                                        <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                            {{ __('Preferred contact window') }}
                                            <span class="text-primary-blue">{{ __('*') }}</span>
                                            </span>
                                        </label>
                                        <div class="relative mt-1">
                                            <select wire:model="preferredContactWindow" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                <option value="">{{ __('Select preferred time') }}</option>
                                                @foreach ($preferredContactWindowList as $contactWindow)
                                                    <option value="{{ $contactWindow->value }}">{{ $contactWindow->getLabel() }}</option>
                                                @endforeach
                                            </select>
                                            <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2 text-[#99A0AE]">
                                                <x-icon-down-arrow2 />
                                            </span>
                                        </div>
                                        @error('preferredContactWindow')
                                            <span class="text-red-500">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="mt-[22px]">
                                        <div class="flex md:items-center items-strat">
                                            <input id="authorize-to-contact-me"
                                                type="checkbox"
                                                value="1"
                                                wire:model.live="authorizeToContactMe"
                                                @if ($authorizeToContactMe == 1) checked @endif
                                                class="w-4 h-4 bg-transpanrent md:mt-0 mt-[3px] rounded-sm shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0" />
                                            @error('authorizeToContactMe')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                            <label for="authorize-to-contact-me" class="ms-2.5 font-normal cursor-pointer text-xs leading-5 tracking-[-0.096px] text-mid-gray">
                                                {{ __('I authorize you to contact me about this estimate request.') }}
                                                <span class="text-primary-blue">{{ __('*') }}</span>
                                            </label>

                                        </div>
                                    </div>
                                </div>
                                <div class="relative flex items-center justify-center md:mt-[52px] mt-9">
                                    <x-frontend.includes.modal-element-loading wire:loading
                                        wire:target="nextStep"
                                        class="rounded-full" />
                                    <a href="javascript:void(0)"
                                        wire:click.prevent="nextStep"
                                        wire:loading.attr="disabled"
                                        wire:target="nextStep"
                                        class="next-btn text-black font-bold text-base leading-6 tracking-[-0.096px] h-[52px] w-full shadow-24xl rounded-full btn-gradient flex items-center justify-center gap-2">
                                        {{ __('Continue to well drilling details') }}
                                    </a>
                                </div>
                            </div>
                            <div id="step2" class="step">
                                <div class="bg-white md:border-[12px] border-[8px]  shadow-19xl border-solid border-blue-1900/[0.5] rounded-[22px] sm:p-8 p-5">
                                    <div class="flex flex-col gap-4 items-start mb-8 sm:flex-row sm:items-center">
                                        <span class="border border-solid border-blue-2000 rounded-[14px] w-[52px] h-[52px] flex items-center justify-center gradient shadow-16xl">
                                            <x-icon-newspaper-line />
                                        </span>
                                        <div class="flex-1 w-full">
                                            <h5 class="mb-1 text-2xl font-medium leading-6 text-black-1200 sm:leading-8 lg:text-2xl md:text-xl">
                                                {{ __('Well Drilling Requirements') }}
                                            </h5>
                                            <p class="text-base font-normal leading-6 text-mid-gray lg:text-base md:text-sm lg::leading-6 md:leading-5">
                                                {{ __('Tell us about your water needs and quality goals.') }}
                                            </p>
                                        </div>
                                    </div>
                                    <div class="pb-8 border-b border-solid border-gray-1200" x-data="{ primaryUse: $wire.entangle('primaryUse').live }">
                                        <div class="mb-3">
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mb-1">
                                                {{ __('Primary Use for the New Well') }}
                                                <span class="text-primary-blue">{{ __('*') }}</span>
                                                </span>
                                            </label>
                                            <p class="text-base font-normal leading-6 text-mid-gray"> {{ __('Check all that apply and provide the requested details.') }}</p>
                                            @error('primaryUse')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        @foreach ($primaryUseList as $primaryUse)
                                            <div class="p-3 mb-3 bg-white rounded-xl border border-solid primary-main border-gray-1200">
                                                <div class="flex items-center">
                                                    <input id="primary-use-{{ $primaryUse->value }}"
                                                        type="checkbox"
                                                        value="{{ $primaryUse->value }}"
                                                        wire:model="primaryUse"
                                                        class="w-4 h-4 rounded-sm bg-transpanrent shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0">
                                                    <label for="primary-use-{{ $primaryUse->value }}" class="ms-3 font-medium cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                        {{ $primaryUse->getLabel() }}
                                                    </label>
                                                </div>

                                                {{-- Residential / Domestic Use Fields --}}
                                                @if ($primaryUse->value === 'residential_domestic')
                                                    <div class="p-3 mt-3 rounded-xl primary-box bg-gray-1400"
                                                        x-show="primaryUse.includes('residential_domestic')"
                                                        x-transition
                                                        style="display: none;">
                                                        <div class="grid grid-cols-2 gap-5">
                                                            <div>
                                                                <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                                    {{ __('Number of people in the home') }}
                                                                    <span class="text-primary-blue">{{ __('*') }}</span>
                                                                </label>
                                                                <input type="text"
                                                                    class="border border-solid border-gray-1200 bg-white rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                                    placeholder="{{ __('e.g 4') }}"
                                                                    wire:model="domestic_no_of_people">
                                                            </div>
                                                            <div>
                                                                <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                                    {{ __('Number of bathrooms') }}
                                                                    <span class="text-primary-blue">{{ __('*') }}</span>
                                                                </label>
                                                                <input type="text"
                                                                    class="border border-solid border-gray-1200 bg-white rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                                    placeholder="{{ __('e.g 2') }}"
                                                                    wire:model="domestin_no_of_bathrooms">
                                                            </div>
                                                        </div>
                                                        <div class="flex items-center mt-3">
                                                            <input id="domestic-swimming-pool-{{ $primaryUse->value }}"
                                                                type="checkbox"
                                                                value="1"
                                                                wire:model="domestic_swimming_pool_garden"
                                                                class="w-4 h-4 rounded-sm bg-transpanrent shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0">
                                                            <label for="domestic-swimming-pool-{{ $primaryUse->value }}" class="ms-3 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                                {{ __('Will you be filling a swimming pool or watering gardens?') }}
                                                            </label>
                                                        </div>
                                                    </div>
                                                @endif

                                                {{-- Irrigation / Agricultural Use Fields --}}
                                                @if ($primaryUse->value === 'irrigation_agricultural')
                                                    <div class="p-3 mt-3 rounded-xl primary-box bg-gray-1400"
                                                        x-show="primaryUse.includes('irrigation_agricultural')"
                                                        x-transition
                                                        style="display: none;">
                                                        <div class="mb-3">
                                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                                {{ __('What will you be irrigating (e.g., lawn, crops, livestock)?') }}
                                                            </label>
                                                            <input type="text"
                                                                class="border border-solid border-gray-1200 bg-white rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                                placeholder="{{ __('e.g., Crop Cultivation, Pasture, Berries, Drought Mitigation') }}"
                                                                wire:model="agriculture_irrigation_purpose">
                                                        </div>
                                                        <div>
                                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                                {{ __('Approximate size of the area?') }}
                                                            </label>
                                                            <input type="text"
                                                                class="border border-solid border-gray-1200 bg-white rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                                placeholder="{{ __('e.g., 5 acres, 20 acres') }}"
                                                                wire:model="agriculture_area_size">
                                                        </div>
                                                    </div>
                                                @endif

                                                {{-- Commercial / Business Use Fields --}}
                                                @if ($primaryUse->value === 'commercial_business')
                                                    <div class="p-3 mt-3 rounded-xl primary-box bg-gray-1400"
                                                        x-show="primaryUse.includes('commercial_business')"
                                                        x-transition
                                                        style="display: none;">
                                                        <div>
                                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                                {{ __('Please briefly describe your business?') }}
                                                            </label>
                                                            <input type="text"
                                                                class="border border-solid border-gray-1200 bg-white rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                                placeholder="{{ __('e.g., Greenhouse, Golf Course, Service Industry, Food Processing') }}"
                                                                wire:model="commercial_business_detail">
                                                        </div>
                                                    </div>
                                                @endif

                                                {{-- Other Use Fields --}}
                                                @if ($primaryUse->value === 'other')
                                                    <div class="p-3 mt-3 rounded-xl primary-box bg-gray-1400"
                                                        x-show="primaryUse.includes('other')"
                                                        x-transition
                                                        style="display: none;">
                                                        <div>
                                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                                {{ __('Please describe any other intended uses.') }}
                                                            </label>
                                                            <input type="text"
                                                                class="border border-solid border-gray-1200 bg-white rounded-full h-10 w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                                placeholder="{{ __('eg. Fire Protection') }}"
                                                                wire:model="other_intented_use_detail">
                                                        </div>
                                                    </div>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                    <div class="pt-8">
                                        <div class="mb-3">
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mb-1">
                                                {{ __('Well Water Quality Goals & Concerns') }}
                                            </label>
                                            <p class="text-base font-normal leading-6 text-mid-gray"> {{ __('Check any of the following that are important to you.') }}</p>
                                            @error('waterQualityGoals')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="grid grid-cols-1 mt-6 md:grid-cols-2 md:gap-6">
                                            @php
                                                $goals = \App\Enums\WaterQualityGoals::cases();
                                                $mid = (int) ceil(count($goals) / 2);
                                                $leftGoals = array_slice($goals, 0, $mid);
                                                $rightGoals = array_slice($goals, $mid);
                                            @endphp
                                            <div>
                                                @foreach ($leftGoals as $goal)
                                                    @php $goalId = 'goal-'.\Illuminate\Support\Str::slug($goal->getLabel()); @endphp
                                                    <div class="{{ $loop->last ? 'md:mb-0 mb-3' : 'mb-3' }} flex items-center">
                                                        <input id="{{ $goalId }}"
                                                            type="checkbox"
                                                            value="{{ $goal->value }}"
                                                            wire:model="waterQualityGoals"
                                                            class="w-4 h-4 rounded-sm bg-transpanrent shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0">
                                                        <label for="{{ $goalId }}" class="ms-3 font-medium cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                            {{ __($goal->getLabel()) }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                            <div class="">
                                                @foreach ($rightGoals as $goal)
                                                    @php $goalId = 'goal-'.\Illuminate\Support\Str::slug($goal->getLabel()); @endphp
                                                    <div class="{{ $loop->last ? 'flex items-center' : 'mb-3 flex items-center' }}">
                                                        <input id="{{ $goalId }}"
                                                            type="checkbox"
                                                            value="{{ $goal->value }}"
                                                            wire:model="waterQualityGoals"
                                                            class="w-4 h-4 rounded-sm bg-transpanrent shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0">
                                                        <label for="{{ $goalId }}" class="ms-3 font-medium cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                            {{ __($goal->getLabel()) }}</label>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center md:gap-6 gap-5 md:flex-row flex-col-reverse justify-center md:mt-[52px] mt-9">
                                    <div class="relative w-full">
                                        <x-frontend.includes.modal-element-loading wire:loading
                                            wire:target="prevStep"
                                            class="rounded-full md:w-[360px] w-full" />
                                        <a href="javascript:void(0)"
                                            wire:click.prevent="prevStep"
                                            class="prev-btn text-mid-gray gap-3 font-medium text-sm leading-5 tracking-[-0.084px] h-[52px] shadow-31xl w-full rounded-full bg-white border border-solid border-gray-1200 flex items-center justify-center">
                                            <x-icon-left-arrow2 /> {{ __('Back') }}
                                        </a>
                                    </div>
                                    <div class="relative w-full">
                                        <x-frontend.includes.modal-element-loading wire:loading
                                            wire:target="nextStep"
                                            class="rounded-full md:w-[360px] w-full" />
                                        <a href="javascript:void(0)"
                                            wire:click.prevent="nextStep"
                                            wire:loading.attr="disabled"
                                            wire:target="nextStep"
                                            class="next-btn text-black font-bold text-base leading-6 tracking-[-0.096px] h-[52px] w-full shadow-24xl rounded-full btn-gradient flex items-center justify-center gap-2">
                                            {{ __('to property details') }}</a>
                                    </div>
                                </div>
                            </div>
                            <div id="step3" class="step">
                                <div class="bg-white md:border-[12px] border-[8px]  shadow-19xl border-solid border-blue-1900/[0.5] rounded-[22px] sm:p-8 p-5">
                                    <div class="flex flex-col gap-4 items-start mb-8 sm:flex-row sm:items-center">
                                        <span class="border border-solid border-blue-2000 rounded-[14px] w-[52px] h-[52px] flex items-center justify-center gradient shadow-16xl">
                                            <x-icon-property-icon />
                                        </span>
                                        <div class="flex-1 w-full">
                                            <h5 class="mb-1 text-2xl font-medium leading-6 text-black-1200 sm:leading-8 lg:text-2xl md:text-xl">
                                                {{ __('Property & Timeline Details') }}</h5>
                                            <p class="text-base font-normal leading-6 text-mid-gray lg:text-base md:text-sm lg::leading-6 md:leading-5">
                                                {{ __('Help us understand your property and project timeline.') }}</p>
                                        </div>
                                    </div>
                                    <div class="pb-8 border-b border-solid border-gray-1200">
                                        <h6 class="mb-5 text-xl font-medium leading-8 text-black-1200">{{ __('Property Details') }}</h6>
                                        <div class="mb-5">
                                            <label class=" text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mb-3">
                                                {{ __('Is there an existing water well on the property?') }} <span class="ml-1 text-primary-blue">{{ __('*') }}</span>

                                            </label>

                                            <ul class="grid grid-cols-1 gap-y-3 gap-x-6 mt-3 sm:grid-cols-2">
                                                <li>
                                                    <div class="flex items-center">
                                                        <input id="is-existing-water-well-yes"
                                                            type="radio"
                                                            wire:model="isExistingWaterWell"
                                                            value="1"
                                                            class="w-4 h-4 text-blue-600 bg-white border-2 border-solid cursor-pointer border-gray-1200 shadow-9xl focus:ring-transpanrent focus:ring-0">
                                                        <label for="is-existing-water-well-yes" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                            {{ __('Yes') }}
                                                        </label>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="flex items-center">
                                                        <input id="is-existing-water-well-no"
                                                            type="radio"
                                                            wire:model="isExistingWaterWell"
                                                            value="0"
                                                            class="w-4 h-4 text-blue-600 bg-white border-2 border-solid cursor-pointer border-gray-1200 shadow-9xl focus:ring-transpanrent focus:ring-0">
                                                        <label for="is-existing-water-well-no" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">No
                                                        </label>
                                                    </div>
                                                </li>
                                            </ul>
                                            @error('isExistingWaterWell')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div class="mb-5">
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096] mb-3">
                                                {{ __('Information about Existing Well (if known)') }}
                                            </label>
                                            <textarea class="border border-solid border-gray-1200 rounded-lg h-[95px] w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="{{ __('Depth, age or any issues...') }}"
                                                wire:model="informationAboutExistingWell"></textarea>
                                        </div>
                                        <div class="">
                                            <label class="gap-px text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mb-3">
                                                {{ __('Is this for a new construction project?') }} <span class="text-primary-blue">{{ __('*') }}</span>
                                            </label>
                                            <ul class="grid grid-cols-1 gap-y-3 gap-x-6 mt-3 sm:grid-cols-2">
                                                <li>
                                                    <div class="flex items-center">
                                                        <input id="is-new-construction-project-yes"
                                                            type="radio"
                                                            value="1"
                                                            wire:model="isNewConstructionProject"
                                                            class="w-4 h-4 text-blue-600 bg-white border-2 border-solid cursor-pointer border-gray-1200 shadow-9xl focus:ring-transpanrent focus:ring-0">
                                                        <label for="is-new-construction-project-yes" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                            {{ __('Yes') }}
                                                        </label>
                                                    </div>
                                                </li>
                                                <li>
                                                    <div class="flex items-center">
                                                        <input id="is-new-construction-project-no"
                                                            type="radio"
                                                            value="0"
                                                            wire:model="isNewConstructionProject"
                                                            class="w-4 h-4 text-blue-600 bg-white border-2 border-solid cursor-pointer border-gray-1200 shadow-9xl focus:ring-transpanrent focus:ring-0">
                                                        <label for="is-new-construction-project-no" class="ms-2.5 font-normal cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                            {{ __('No') }}
                                                        </label>
                                                    </div>
                                                </li>
                                            </ul>
                                            @error('isNewConstructionProject')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="pt-8">
                                        <h6 class="mb-5 text-xl font-medium leading-8 text-black-1200">{{ __('Timeline & Location') }}</h6>
                                        <div class="mb-5">
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('Desired Project Timeline') }} <span class="text-primary-blue">{{ __('*') }}</span>
                                                </span>
                                            </label>
                                            <div class="relative mt-1">
                                                <select wire:model="desiredProjectTimeline" class="text-gray-1500 shadow-3xl text-sm font-normal leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-10 w-full px-3">
                                                    <option>{{ __('Select a timeline') }}</option>
                                                    @foreach ($desiredProjectTimelineList as $timeline)
                                                        <option value="{{ $timeline['value'] }}">{{ $timeline['name'] }}</option>
                                                    @endforeach
                                                </select>
                                                <span class="flex absolute right-4 top-1/2 justify-center items-center -translate-y-1/2">
                                                    <x-icon-down-arrow2 />
                                                </span>
                                            </div>
                                            @error('desiredProjectTimeline')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                        <div>
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('Well Site Location') }} <span class="text-primary-blue">{{ __('*') }}</span>
                                                </span>
                                            </label>
                                            <textarea wire:model="wellSiteLocation"
                                                class="border border-solid border-gray-1200 rounded-lg h-[95px] w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="Describe where you'd like the well drilled"></textarea>
                                            @error('wellSiteLocation')
                                                <span class="text-red-500">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center md:gap-6 gap-5 md:flex-row flex-col-reverse justify-center md:mt-[52px] mt-9">
                                    <div class="relative w-full">
                                        <x-frontend.includes.modal-element-loading wire:loading
                                            wire:target="prevStep"
                                            class="rounded-full md:w-[360px] w-full" />
                                        <a href="javascript:void(0)"
                                            wire:click.prevent="prevStep"
                                            class="prev-btn text-mid-gray gap-3 font-medium text-sm leading-5 tracking-[-0.084px] h-[52px] shadow-31xl w-full rounded-full bg-white border border-solid border-gray-1200 flex items-center justify-center">
                                            <x-icon-left-arrow2 /> {{ __('Back') }}
                                        </a>
                                    </div>
                                    <div class="relative w-full">
                                        <x-frontend.includes.modal-element-loading wire:loading
                                            wire:target="nextStep"
                                            class="rounded-full md:w-[360px] w-full" />
                                        <a href="javascript:void(0)"
                                            wire:click.prevent="nextStep"
                                            wire:loading.attr="disabled"
                                            wire:target="nextStep"
                                            class="next-btn text-black font-bold text-base leading-6 tracking-[-0.096px] h-[52px] w-full shadow-24xl rounded-full btn-gradient flex items-center justify-center gap-2">
                                            {{ __('Continue to complete your system') }}</a>
                                    </div>
                                </div>
                            </div>
                            <div id="step4" class="step">
                                <div class="bg-white md:border-[12px] border-[8px]  shadow-19xl border-solid border-blue-1900/[0.5] rounded-[22px] sm:p-8 p-5">
                                    <div class="flex flex-col gap-4 items-start mb-8 sm:flex-row sm:items-center">
                                        <span class="border border-solid border-blue-2000 rounded-[14px] w-[52px] h-[52px] flex items-center justify-center gradient shadow-16xl">
                                            <x-icon-property-icon />
                                        </span>
                                        <div class="flex-1 w-full">
                                            <h5 class="mb-1 text-2xl font-medium leading-6 text-black-1200 sm:leading-8 lg:text-2xl md:text-xl">
                                                {{ __('Complete Your Water System') }}</h5>
                                            <p class="text-base font-normal leading-6 text-mid-gray lg:text-base md:text-sm lg::leading-6 md:leading-5">
                                                {{ __('Get a comprehensive estimate for a fully operational water system.') }}</p>
                                        </div>
                                    </div>
                                    <div class="pb-8 border-b border-solid border-gray-1200">
                                        <div class="p-4 rounded-xl bg-gray-1400">
                                            <h4 class="text-black-1200 font-medium text-lg leading-6 tracking-[-0.24px] mb-1">
                                                {{ __('Why Include Pump Installation?') }}</h4>
                                            <p class="text-mid-gray text-sm leading-5 font-normal tracking-[-0.096px]">
                                                {{ __("A well isn't complete without a pump system. To have running water in your home or property, you'll need:") }}</p>
                                            <ul class="pb-3 mt-3 border-b border-solid border-gray-1200">
                                                <li class="flex gap-2 items-center mb-1.5">
                                                    <span class="flex justify-center items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                    <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px]">
                                                        <strong class="font-bold">{{ __('Plan') }}</strong>
                                                        {{ __('Well pump to bring water to the surface') }}
                                                    </p>
                                                </li>
                                                <li class="flex gap-2 items-center mb-1.5">
                                                    <span class="flex justify-center items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                    <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px]">
                                                        <strong class="font-bold">{{ __('Avoid') }}</strong>
                                                        {{ __('Pressure tank to maintain consistent water pressure') }}
                                                    </p>
                                                </li>
                                                <li class="flex gap-2 items-center mb-1.5">
                                                    <span class="flex justify-center items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                    <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px]">
                                                        <strong class="font-bold">{{ __('Coordinate') }}</strong>
                                                        {{ __('Pressure switch and electrical connections') }}
                                                    </p>
                                                </li>
                                                <li class="flex gap-2 items-center mb-1.5">
                                                    <span class="flex justify-center items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round" />
                                                        </svg>
                                                    </span>
                                                    <p class="text-mid-gray font-normal text-sm leading-5 tracking-[-0.096px]">
                                                        <strong class="font-bold">{{ __('Know') }}</strong>
                                                        {{ __('Professional installation for optimal performance') }}
                                                    </p>
                                                </li>
                                            </ul>
                                            <p class="text-black-1200 font-normal text-sm leading-5 tracking-[-0.096px] mt-3">
                                                {{ __('Most property owners (99%) choose to include this to get a complete, move-in-ready water system and avoid coordinating separate contractors.') }}</p>
                                        </div>
                                        <div class="bg-blue-1400/[0.1] rounded-xl p-4 mt-5">
                                            <span class="inline-flex gap-1 items-center px-1.5 h-5 text-xs font-medium leading-4 rounded-full border border-solid text-green-1200 border-green-1200 bg-green-1300">
                                                <svg xmlns="http://www.w3.org/2000/svg"
                                                    width="14"
                                                    height="14"
                                                    viewBox="0 0 14 14"
                                                    fill="none">
                                                    <path d="M7.00014 10.7556L2.76834 13.1244L3.71334 8.36761L0.152344 5.07481L4.96854 4.50361L7.00014 0.0996094L9.03174 4.50361L13.8479 5.07481L10.2869 8.36761L11.2319 13.1244L7.00014 10.7556Z" fill="#178C4E" />
                                                </svg>
                                                {{ __('Recommended') }}
                                            </span>
                                            <div class="flex items-start mt-3">
                                                <input id="complete-estimate"
                                                    type="checkbox"
                                                    value="{{ $completeEstimate }}"
                                                    wire:model="completeEstimate"
                                                    @if ($completeEstimate == 1) checked @endif
                                                    class="mt-1 w-4 h-4 rounded-sm bg-transpanrent shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0">
                                                <label for="complete-estimate" class="ms-2.5 font-medium cursor-pointer text-sm leading-5 tracking-[-0.096px] text-black-1200">
                                                    {{ __('I Include a complete well pump system estimate') }}
                                                    <p class="mt-1 text-xs font-normal leading-4 text-mid-gray">
                                                        {{ __('Get everything you need in one comprehensive quote.') }}</p>
                                                </label>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="pt-8">
                                        <h4 class="mb-5 text-xl font-medium leading-7 text-black-1200">
                                            {{ __('Well Pump Installation Details') }}
                                        </h4>
                                        <div class="flex flex-col mb-5">
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-sm leading-5 tracking-[-0.096px] mb-1">
                                                {{ __('Notes for the pump installer') }}
                                            </label>
                                            <textarea class="border border-solid border-gray-1200 rounded-lg h-[95px] w-full shadow-3xl pl-3 font-normal text-sm leading-5 tracking-[-0.096px] text-gray-1500 placeholder:text-gray-1500"
                                                placeholder="{{ __('e.g., “Pressure system needs to go in the garage,” or “Any other notes or questions”') }}"
                                                wire:model="notes">
                                            </textarea>
                                        </div>
                                        <div class="flex flex-col">
                                            <label class="flex items-center gap-px text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mb-1">
                                                {{ __('File upload') }}
                                            </label>
                                            <p class="text-mid-gray text-sm font-normal leading-5 tracking-[-0.096px]">
                                                {{ __('Upload Photos of Installation Area') }}</p>

                                            {{-- File Upload Input --}}
                                            <div class="mt-3">
                                                <label for="newAttachments" class="fileUpload cursor-pointer border border-dashed border-gray-1600 text-center p-4 rounded-xl min-h-[206px] relative flex items-center justify-center flex-col">
                                                    <input type="file"
                                                        id="newAttachments"
                                                        wire:model="newAttachments"
                                                        multiple
                                                        accept="image/*,application/pdf"
                                                        class="hidden"
                                                        @if (count($attachments) >= 5) disabled @endif>

                                                    <div wire:loading
                                                        wire:target="newAttachments"
                                                        class="text-primary-blue">
                                                        <x-icon-loading-spinner class="mx-auto w-8 h-8 animate-spin" />
                                                        <p class="mt-2 text-sm">{{ __('Uploading...') }}</p>
                                                    </div>

                                                    <div wire:loading.remove
                                                        wire:target="newAttachments"
                                                        class="flex flex-col items-center">
                                                        <x-icon-upload-new />
                                                        <h5 class="sm:text-sm text-xs font-medium leading-5 mt-5 tracking-[-0.096px] text-black-1200 text-center">
                                                            {{ __('Choose a file or drag &amp; drop it here.') }}</h5>
                                                        <p class="mt-1.5 mb-5 sm:text-sm text-xs font-normal leading-5 tracking-[-0.096px] text-mid-gray text-center">
                                                            {{ __('JPEG, PNG, PDF formats, up to 10 MB each.') }}
                                                        </p>
                                                        <span class="text-mid-gray font-normal sm:text-sm text-xs leading-5 tracking-[-0.096px] border border-solid border-gray-1200 rounded-full h-8 w-[104px] flex items-center justify-center">
                                                            {{ __('Browse Files') }}
                                                        </span>
                                                    </div>
                                                </label>

                                                @error('newAttachments.*')
                                                    <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
                                                @enderror
                                                @error('newAttachments')
                                                    <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
                                                @enderror
                                                @error('attachments.*')
                                                    <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
                                                @enderror
                                                @error('attachments')
                                                    <span class="mt-1 text-sm text-red-500">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            {{-- File Preview Section --}}
                                            @if (count($attachments) > 0)
                                                <div class="mt-4 space-y-2">
                                                    <p class="text-sm font-medium text-black-1200">{{ __('Selected Files:') }} ({{ count($attachments) }}/5)</p>
                                                    <div class="grid grid-cols-1 gap-2">
                                                        @foreach ($attachments as $index => $attachment)
                                                            <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg border border-gray-1200">
                                                                <div class="flex flex-1 gap-3 items-center min-w-0">
                                                                    {{-- File Icon/Thumbnail --}}
                                                                    <div class="flex-shrink-0">
                                                                        @if (str_starts_with($attachment->getMimeType(), 'image/'))
                                                                            <img src="{{ $attachment->temporaryUrl() }}"
                                                                                alt="Preview"
                                                                                class="object-cover w-12 h-12 rounded">
                                                                        @else
                                                                            <div class="flex justify-center items-center w-12 h-12 bg-red-100 rounded">
                                                                                <x-icon-file-pdf class="w-6 h-6 text-red-600" />
                                                                            </div>
                                                                        @endif
                                                                    </div>

                                                                    {{-- File Info --}}
                                                                    <div class="flex-1 min-w-0">
                                                                        <p class="text-sm font-medium truncate text-black-1200">
                                                                            {{ $attachment->getClientOriginalName() }}
                                                                        </p>
                                                                        <p class="text-xs text-mid-gray">
                                                                            {{ number_format($attachment->getSize() / 1024, 2) }} KB
                                                                        </p>
                                                                    </div>
                                                                </div>

                                                                {{-- Remove Button --}}
                                                                <button type="button"
                                                                    wire:click="removeAttachment({{ $index }})"
                                                                    class="flex-shrink-0 ml-2 text-red-600 hover:text-red-800">
                                                                    <x-icon-close-circle class="w-5 h-5" />
                                                                </button>
                                                            </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="bg-gray-1400 mt-8 border border-solid border-gray-1200 rounded-[18px] p-6">
                                            <h4 class="text-black-1200 font-medium text-base leading-6 tracking-[-0.176px] mb-1.5">
                                                {{ __('Confirm Property Location') }}
                                            </h4>
                                            <p class="text-base font-normal leading-6 text-mid-gray">
                                                {{ __('Before submitting, please verify this estimate is for the correct property:') }}
                                            </p>
                                            <h5 class="text-black-1200 font-normal mt-4 text-lg leading-6 tracking-[-0.24px]">
                                                {{ $address ?? __('No address provided') }}</h5>
                                            <div class="flex items-start mt-4">
                                                <input id="property-location-true"
                                                    type="checkbox"
                                                    value="{{ $propertyLocation }}"
                                                    checked="{{ $propertyLocation == 1 ? 'checked' : '' }}"
                                                    wire:model="propertyLocation"
                                                    class="w-4 h-4 rounded-sm bg-transpanrent shadow-9xl text-primary-blue border-gray-1600 focus:ring-transpanrent dark:focus:ring-transpanrent focus:ring-0">
                                                <label for="property-location-true" class="text-xs font-medium leading-4 cursor-pointer ms-2.5 text-mid-gray">
                                                    {{ __('Yes, this is the correct property location') }}
                                                    <span class="text-primary-blue">{{ __('*') }}</span>
                                                </label>
                                                @error('propertyLocation')
                                                    <span class="text-red-500">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="bg-gray-1400 mt-5 rounded-xl px-6 py-4">
                                            <ul class="flex items-center flex-wrap gap-3">
                                                <li class="text-primary-blue border border-solid border-primary-blue rounded-full bg-blue-1200 h-6 text-xs gap-1 font-medium leading-4 inline-flex px-2.5 items-center justify-center">
                                                    <span class="flex items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round">
                                                            </path>
                                                        </svg>
                                                    </span>
                                                    {{ __('Free estimate') }}
                                                </li>
                                                <li class="text-primary-blue border border-solid border-primary-blue rounded-full bg-blue-1200 h-6 text-xs gap-1 font-medium leading-4 inline-flex px-2.5 items-center justify-center">
                                                    <span class="flex items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round">
                                                            </path>
                                                        </svg>
                                                    </span>
                                                    {{ __('No obligations') }}
                                                </li>
                                                <li class="text-primary-blue border border-solid border-primary-blue rounded-full bg-blue-1200 h-6 text-xs gap-1 font-medium leading-4 inline-flex px-2.5 items-center justify-center">
                                                    <span class="flex items-center w-4 h-4">
                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                            width="16"
                                                            height="16"
                                                            viewBox="0 0 16 16"
                                                            fill="none">
                                                            <path d="M13.3337 4L6.00033 11.3333L2.66699 8"
                                                                stroke="#335CFF"
                                                                stroke-width="2"
                                                                stroke-linecap="round"
                                                                stroke-linejoin="round">
                                                            </path>
                                                        </svg>
                                                    </span>
                                                    {{ __('24 - 48 hours response') }}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex items-center md:gap-6 gap-5 md:flex-row flex-col-reverse justify-center md:mt-[52px] mt-9">
                                    <div class="relative w-full">
                                        <x-frontend.includes.modal-element-loading wire:loading
                                            wire:target="prevStep"
                                            class="rounded-full md:w-[360px] w-full" />
                                        <a href="javascript:void(0)"
                                            wire:click.prevent="prevStep"
                                            class="prev-btn text-mid-gray gap-3 font-medium text-sm leading-5 tracking-[-0.084px] h-[52px] shadow-31xl w-full rounded-full bg-white border border-solid border-gray-1200 flex items-center justify-center">
                                            <x-icon-left-arrow2 /> {{ __('Back') }}
                                        </a>
                                    </div>

                                    <div class="relative w-full">
                                        <x-frontend.includes.modal-element-loading wire:loading
                                            wire:target="submit"
                                            class="rounded-full md:w-[360px] w-full" />
                                        <a href="javascript:void(0)"
                                            wire:click.prevent="submit"
                                            class="next-btn text-black font-bold text-base leading-6 tracking-[-0.096px] h-[52px] w-full shadow-24xl rounded-full btn-gradient flex items-center justify-center gap-2">
                                            {{ __('Request my detailed estimate') }}
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
