<div class="{{ !empty($partners) ? 'p-3' : '' }}">
    @if (!empty($partners))
        <div style="--bg-partner-desktop: url('{{ $partner_desktop_bg_image }}');" class="bg-[image:var(--bg-partner-desktop)] bg-cover bg-center bg-no-repeat rounded-3xl md:py-20 py-12">
            <div class="max-w-[720px] w-full mx-auto text-center md:px-0 px-6">
                <h3 class="xl:text-5xl lg:text-4xl text-[40px] text-center font-normal text-white lg:leading-[56px] leading-[48px]  md:tracking-[-0.32px] tracking-[-0.8px]">
                    {!! $heading !!}
                </h3>
                <div class="text-lg font-normal mt-1.5 leading-6 tracking-[-0.24px] text-white sm:max-w-full max-w-[263px] w-full sm:mx-0 mx-auto">
                    {!! $description !!}
                </div>
            </div>
            <div class="mt-16">
                <div class="overflow-hidden w-full marquee-wrapper">
                    <div class="flex gap-6 marquee-inner">
                        @foreach ($partners as $partner)
                            @php
                                $jobRole = \App\Models\Job\JobRole::find($partner['role']);
                            @endphp
                            <div class="p-2 rounded-2xl ratio">
                                <a href="#">
                                    <img src="{{ \Illuminate\Support\Facades\Storage::url($partner['image']) }}"
                                        alt="{{ $partner['name'] }}"
                                        class="rounded-lg object-cover w-full transition-all ease-in-out duration-500 h-[182px] object-center"
                                        loading="lazy" />
                                    <div class="mt-2 mb-0.5 text-center">
                                        <h4 class="text-base font-semibold leading-6 text-white">
                                            {{ $partner['name'] }}
                                        </h4>
                                        <p class="text-xs font-semibold leading-4 text-white">
                                            {{ $jobRole->job_role_name }} @ {{ $partner['company_name'] }}
                                        </p>
                                    </div>
                                </a>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
