<section class="py-6 bg-gray-1800 md:py-20">
    @if ($members->isNotEmpty())
        <div class="max-w-[1232px] w-full  mx-auto lg:px-4 px-0">
            <div class="flex flex-col justify-between items-start lg:flex-row md:mb-[64px] mb-6 lg:px-0 px-6">
                <div class="mb-6 lg:mb-0">
                    <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-[32px] text-black-1200 font-normal lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.96px] tracking-[-0.64px]">
                        {!! $heading !!}
                    </h3>
                    @if (!empty($description))
                        <div class="text-mid-gray font-normal xl:text-lg md:text-sm text-base xl:leading-6 md:leading-5 leading-6 md:tracking-[-0.27px] tracking-[-0.24px] mt-1.5">
                            {!! $description !!}
                        </div>
                    @endif
                </div>
                <a href="{{ route('member.index') }}" class="text-[19.6px] shadow-21xl btn-gradient font-bold leading-7 tracking-[-0.118px] text-black rounded-full gap-[11px] bg-black-1200 h-[56px] w-[289px] flex items-center justify-center">
                    {{ __('View All Contractors') }}
                    <span class="flex justify-center items-center w-7 h-7">
                        <x-icon-flashlight-fill class="brightness-0" />
                    </span>
                </a>
            </div>

            @if ($memberSelectionType === 'use_selected_members')
                {{-- Show selected members only without tabs --}}
                <div class="relative">
                    <div>
                        <div class="swiper espSwiper overflow-visible!">
                            <div class="swiper-wrapper">
                                @foreach ($members as $member)
                                    <div class="swiper-slide">
                                        @if ($member->membershipType->value === \App\Enums\MembershipType::Featured->value)
                                            <x-frontend.member.listing.member-card-featured-gallery :member="$member"
                                                :loop="$loop"
                                                :desktopSlides="5"
                                                wire:key="list-member-{{ $member?->uuid }}" />
                                        @else
                                            <x-frontend.member.listing.member-card-pro :member="$member"
                                                :loop="$loop"
                                                wire:key="list-member-{{ $member?->uuid }}" />
                                        @endif
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    @if ($members->count() > 1)
                        <div class="sm:hidden mt-8 flex gap-5 justify-center items-center">
                            <div class="swiper-button-prev swiper-button-prev3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                                <x-icon-swiper-left-v3 />
                            </div>
                            <div class="swiper-button-next swiper-button-next3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                                <x-icon-swiper-right-v3 />
                            </div>
                        </div>
                    @endif

                </div>
            @elseif ($memberSelectionType === 'use_latest_members' && $categories->isNotEmpty())
                {{-- Show tabs with categories --}}
                <div class="mb-10 overflow-x-auto">
                    <ul class="flex gap-2 lg:w-auto w-[940px] lg:pb-0 pb-2.5 lg:px-0 px-6"
                        id="home-member-tabs"
                        data-tabs-toggle="#home-member-tabs-content"
                        data-tabs-active-classes="text-blue-1500 bg-blue-1400/10 border-blue-1400"
                        data-tabs-inactive-classes="text-mid-gray bg-white border-gray-2200"
                        role="tablist">
                        {{-- All Tab --}}
                        <li role="presentation">
                            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                                id="All-styled-tab"
                                data-tabs-target="#styled-All"
                                type="button"
                                role="tab"
                                aria-controls="All"
                                aria-selected="true"
                                wire:click="loadCategoryMembers(null)">
                                {{ __('All') }}
                            </button>
                        </li>

                        {{-- Category Tabs --}}
                        @foreach ($categories as $category)
                            <li role="presentation">
                                <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                                    id="category-{{ $category->slug }}-styled-tab"
                                    data-tabs-target="#styled-category-{{ $category->slug }}"
                                    type="button"
                                    role="tab"
                                    aria-controls="category-{{ $category->slug }}"
                                    aria-selected="false"
                                    wire:click="loadCategoryMembers('{{ $category->slug }}')">
                                    @include('components.frontend.member.listing.partials.member-cateogry-title', ['category' => $category])
                                </button>
                            </li>
                        @endforeach
                    </ul>
                </div>

                <div id="home-member-tabs-content">
                    {{-- All Tab Content --}}
                    <div class="lg:px-0 px-6"
                        id="styled-All"
                        role="tabpanel"
                        aria-labelledby="All-tab">
                        <div class="relative">
                            <div>
                                <div class="swiper espSwiper overflow-visible!">
                                    <div class="swiper-wrapper">
                                        @foreach ($members as $member)
                                            <div class="swiper-slide">
                                                @if ($member->membershipType->value === \App\Enums\MembershipType::Featured->value)
                                                    <x-frontend.member.listing.member-card-featured-gallery :member="$member"
                                                        :loop="$loop"
                                                        :desktopSlides="5"
                                                        wire:key="list-member-{{ $member?->uuid }}" />
                                                @else
                                                    <x-frontend.member.listing.member-card-pro :member="$member"
                                                        :loop="$loop"
                                                        wire:key="list-member-{{ $member?->uuid }}" />
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="sm:hidden mt-8 flex gap-5 justify-center items-center">
                                <div class="swiper-button-prev swiper-button-prev3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                                    <x-icon-swiper-left-v3 />
                                </div>
                                <div class="swiper-button-next swiper-button-next3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                                    <x-icon-swiper-right-v3 />
                                </div>
                            </div>
                        </div>
                    </div>

                    {{-- Category Tab Content --}}
                    @foreach ($categories as $category)
                        <div class="lg:px-0 px-6 hidden"
                            id="styled-category-{{ $category->slug }}"
                            role="tabpanel"
                            aria-labelledby="category-{{ $category->slug }}-tab">
                            <div class="relative">
                                <div>
                                    <div class="swiper espSwiper overflow-visible!">
                                        <div class="swiper-wrapper">
                                            @foreach ($members->take(3) as $member)
                                                <div class="swiper-slide">
                                                    @if ($member->membershipType->value === \App\Enums\MembershipType::Featured->value)
                                                        <x-frontend.member.listing.member-card-featured-gallery :member="$member"
                                                            :loop="$loop"
                                                            :desktopSlides="5"
                                                            wire:key="list-member-cat-{{ $category->slug }}-{{ $member?->uuid }}" />
                                                    @else
                                                        <x-frontend.member.listing.member-card-pro :member="$member"
                                                            :loop="$loop"
                                                            wire:key="list-member-cat-{{ $category->slug }}-{{ $member?->uuid }}" />
                                                    @endif
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>

                                <div class="sm:hidden mt-8 flex gap-5 justify-center items-center">
                                    <div class="swiper-button-prev swiper-button-prev3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                                        <x-icon-swiper-left-v3 />
                                    </div>
                                    <div class="swiper-button-next swiper-button-next3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                                        <x-icon-swiper-right-v3 />
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @endif
        </div>
    @endif
</section>

{{-- <div class="max-w-[1232px] w-full  mx-auto lg:px-4 px-0"> --}}
{{-- <div class="flex flex-col justify-between items-start lg:flex-row md:mb-[64px] mb-6 lg:px-0 px-6"> --}}
{{-- <div class="mb-6 lg:mb-0">
            <h3 class="xl:text-5xl lg:text-4xl md:text-[40px] text-[32px] text-black-1200 font-normal lg:leading-[56px] md:leading-[48px] leading-10 md:tracking-[-0.96px] tracking-[-0.64px]">
                ESP
                <span class="italic font-InstrumentSerif">top rated companies</span>
                near you in
                <span class="italic font-InstrumentSerif">Vancouver</span>
            </h3>
            <p class="text-mid-gray font-normal xl:text-lg md:text-sm text-base xl:leading-6 md:leading-5 leading-6 md:tracking-[-0.27px] tracking-[-0.24px] mt-1.5">
                Licensed, verified professionals ready to serve your property
            </p>
        </div> --}}
{{-- <a href="#" class="text-[19.6px] shadow-21xl btn-gradient font-bold leading-7 tracking-[-0.118px] text-black rounded-full gap-[11px] bg-black-1200 h-[56px] w-[289px] flex items-center justify-center">View All Contractors <span class="flex justify-center items-center w-7 h-7"><img src="images/flashlight-fill.svg"
            alt=""
            class="brightness-0" /></span></a> --}}
{{-- </div> --}}
{{-- <div class="mb-10 overflow-x-auto">
    <ul class="flex gap-2 lg:w-auto w-[940px] lg:pb-0 pb-2.5 lg:px-0 px-6"
        id="default-styled-tab"
        data-tabs-toggle="#default-styled-tab-content"
        data-tabs-active-classes="text-blue-1500 bg-blue-1400/10 border-blue-1400"
        data-tabs-inactive-classes="text-mid-gray bg-white border-gray-2200"
        role="tablist">
        <li class="" role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="All-styled-tab"
                data-tabs-target="#styled-All"
                type="button"
                role="tab"
                aria-controls="All"
                aria-selected="false">All</button>
        </li>
        <li class="" role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Water-styled-tab"
                data-tabs-target="#styled-Water"
                type="button"
                role="tab"
                aria-controls="Water"
                aria-selected="false">Water</button>
        </li>
        <li class="" role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Pump-styled-tab"
                data-tabs-target="#styled-Pump"
                type="button"
                role="tab"
                aria-controls="Pump"
                aria-selected="false">Pump</button>
        </li>
        <li role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Geotechnical-styled-tab"
                data-tabs-target="#styled-Geotechnical"
                type="button"
                role="tab"
                aria-controls="Geotechnical"
                aria-selected="false">Geotechnical</button>
        </li>
        <li role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Environmental-styled-tab"
                data-tabs-target="#styled-Environmental"
                type="button"
                role="tab"
                aria-controls="Environmental"
                aria-selected="false">Environmental</button>
        </li>
        <li role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Septic-styled-tab"
                data-tabs-target="#styled-Septic"
                type="button"
                role="tab"
                aria-controls="Septic"
                aria-selected="false">Septic</button>
        </li>
        <li role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Irrigation-styled-tab"
                data-tabs-target="#styled-Irrigation"
                type="button"
                role="tab"
                aria-controls="Irrigation"
                aria-selected="false">Irrigation</button>
        </li>
        <li role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Engineering-styled-tab"
                data-tabs-target="#styled-Engineering"
                type="button"
                role="tab"
                aria-controls="Engineering"
                aria-selected="false">Engineering</button>
        </li>
        <li role="presentation">
            <button class="flex items-center justify-center font-medium text-base leading-5  tracking-[-0.096px] rounded-md h-11 px-3.5 cursor-pointer hover:text-blue-1400 hover:bg-blue-1400/10 border border-solid  hover:border-blue-1400 transition-all duration-500 ease-in-out"
                id="Renewable-styled-tab"
                data-tabs-target="#styled-Renewable"
                type="button"
                role="tab"
                aria-controls="Renewable"
                aria-selected="false">Renewable</button>
        </li>
    </ul>
</div> --}}
<!--<div id="default-styled-tab-content" class="lg:px-0 px-6">
    <div class="hidden"
        id="styled-All"
        role="tabpanel"
        aria-labelledby="All-tab">
        <div class="relative">
            <div class="">
                <div class="swiper espSwiper overflow-visible!">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                             {{-- include 'include/home/home-featured-card.php'; ?> --}}
                        </div>
                        <div class="swiper-slide">
                             {{-- include 'include/home/home-featured-card.php'; ?> --}}
                        </div>
                        <div class="swiper-slide">
                             {{-- include 'include/home/home-featured-card.php'; ?> --}}
                        </div>
                        <div class="swiper-slide">
                             {{-- include 'include/home/home-featured-card.php'; ?> --}}
                        </div>
                        <div class="swiper-slide">
                             {{-- include 'include/home/home-featured-card.php'; ?> --}}
                        </div>
                        <div class="swiper-slide">
                             {{-- include 'include/home/home-featured-card.php'; ?> --}}
                        </div>
                    </div>
                </div>
            </div>
            <div class="sm:hidden mt-8 flex gap-5 justify-center items-center">
                <div class="swiper-button-prev swiper-button-prev3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                    <svg class="!w-3 !h-3"
                        width="12"
                        height="12"
                        viewBox="0 0 12 12"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M2.871 5.2793H12V6.7793H2.871L6.894 10.8023L5.8335 11.8628L0 6.0293L5.8335 0.195801L6.894 1.2563L2.871 5.2793Z"
                            fill="#525866"
                            class="group-hover:fill-black-1200" />
                    </svg>

                </div>
                <div class="swiper-button-next swiper-button-next3 group !mt-0 after:hidden !static bg-white hover:bg-gray-1400 border border-solid border-gray-1200 hover:border-gray-1400 rounded-full !w-10 !h-10 shadow-3xl">
                    <svg class="!w-3 !h-3"
                        width="12"
                        height="12"
                        viewBox="0 0 12 12"
                        fill="none"
                        xmlns="http://www.w3.org/2000/svg">
                        <path d="M9.129 5.2793L5.106 1.2563L6.1665 0.195801L12 6.0293L6.1665 11.8628L5.106 10.8023L9.129 6.7793H0V5.2793H9.129Z"
                            fill="#525866"
                            class="group-hover:fill-black-1200" />
                    </svg>
                </div>
            </div>
        </div>
    </div>
    <div class="hidden"
        id="styled-Water"
        role="tabpanel"
        aria-labelledby="Water-tab">2
    </div>
    <div class="hidden"
        id="styled-Pump"
        role="tabpanel"
        aria-labelledby="Pump-tab">3
    </div>
    <div class="hidden"
        id="styled-Geotechnical"
        role="tabpanel"
        aria-labelledby="Geotechnical-tab">4
    </div>
    <div class="hidden"
        id="styled-Environmental"
        role="tabpanel"
        aria-labelledby="Environmental-tab"> 5
    </div>
    <div class="hidden"
        id="styled-Septic"
        role="tabpanel"
        aria-labelledby="Septic-tab">6
    </div>
    <div class="hidden"
        id="styled-Irrigation"
        role="tabpanel"
        aria-labelledby="Irrigation-tab"> 7</div>
    <div class="hidden"
        id="styled-Engineering"
        role="tabpanel"
        aria-labelledby="Engineering-tab">8
    </div>
    <div class="hidden"
        id="styled-Renewable"
        role="tabpanel"
        aria-labelledby="Renewable-tab">9 </div>
</div>-->

{{-- </div> --}}
