@extends('layouts.app')

@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places,marker" async defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush
@push('scripts')
    <script>
        // Initialize map as soon as the DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize the map once with default settings
            if (window.google && window.google.maps) {
                // Use the new module format
                window.ESPDirectoryMap.init();
            } else {
                // If Google Maps is not yet loaded, wait for it
                document.addEventListener('google-maps-loaded', function() {
                    window.ESPDirectoryMap.init();
                });
            }
        });
    </script>
@endpush

@section('content')
    <livewire:frontend.member.listing.search-result.search-result-map-view :page="$page" :viewType="$viewType" :breadcrumbs="$breadcrumbs" />
@endsection
