@extends('layouts.app')
@php
    if ($user->membershipType->value == App\Enums\MembershipType::Free->value) {
        $marginTop = 'md:mt-[-84px] sm:-mt-11 -mt-2.5';
    } else {
        $marginTop = 'mt-6';
    }
@endphp
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@push('styles')
    <style>
        /* Hide scrollbar for tab container */
        .main-tabs::-webkit-scrollbar {
            display: none;
        }

        .main-tabs {
            -ms-overflow-style: none;
            /* IE and Edge */
            scrollbar-width: none;
            /* Firefox */
        }
    </style>
@endpush
@section('content')
    <section Class="py-8">
        <x-frontend.member.profile.partials.profile-intro :user="$user" :reviewsStats="$reviewsStats" />
    </section>

    <!----- GALLERY  SEC ------>
    @if ($user->membershipType->value !== App\Enums\MembershipType::Free->value)
        <section>
            <div class="max-w-[1310px] w-full mx-auto md:px-4">
                <x-frontend.member.profile.partials.profile-gallery :user="$user" />
            </div>
        </section>
    @endif

    <!----- Tabs  SEC ------>
    <section class="py-8">
        <div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
            <div class="flex flex-col gap-0 items-start md:flex-row md:gap-8">
                <div class="xl:w-[calc(100%_-_447px)] md:w-[calc(100%_-_320px)] w-full">
                    <div>
                        <div class="sticky top-0 bg-white" style="z-index: 10;">
                            <div class="flex relative items-center py-4 border-b border-gray-1200" id="tabScrollerContainer">
                                <!-- Gradient overlay - only show when right arrow is visible -->
                                <span class="shadow-box flex items-center h-full w-[    23px] bg-gradient-to-r from-white/[0] to-white absolute right-0 top-0"></span>
                                <a href="#."
                                    id="arrowLeft"
                                    class="flex relative z-50 justify-center items-center w-8 h-8 rounded-full border border-solid left-arrow border-gray-1200 shadow-3xl">
                                    <x-icon-swiper-left-arrow class="w-4 h-4" />
                                </a>
                                <div class="overflow-x-auto flex-1 w-full main-tabs">
                                    <ul class="flex gap-2 w-max scroll-container"
                                        id="default-styled-tab"
                                        data-tabs-active-classes="bg-black-1200 text-white"
                                        data-tabs-inactive-classes="text-mid-gray hover:bg-black-1200 hover:text-white"
                                        role="tablist">
                                        <!-- Overview Tab -->
                                        <li role="presentation">
                                            <button class="cursor-pointer inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px]"
                                                id="Overview-styled-tab"
                                                data-tabs-target="#styled-Overview"
                                                type="button"
                                                role="tab"
                                                aria-controls="Overview"
                                                aria-selected="{{ $activeTab == 'overview' ? 'true' : 'false' }}">{{ __('Overview') }}</button>
                                        </li>
                                        <!-- Dynamic Tabs -->
                                        @foreach ($tabs as $key => $tab)
                                            <li role="presentation">
                                                <button class="cursor-pointer inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px]"
                                                    id="{{ $tab['id'] }}-styled-tab"
                                                    data-tabs-target="#styled-{{ $tab['id'] }}"
                                                    type="button"
                                                    role="tab"
                                                    aria-controls="{{ $tab['label'] }}"
                                                    aria-selected="{{ $activeTab == $key ? 'true' : 'false' }}">{{ __($tab['label']) }}</button>
                                            </li>
                                        @endforeach
                                    </ul>
                                </div>
                                <span class="shadow-box2 flex items-center h-full w-[123px] bg-gradient-to-l from-white/[0] to-white absolute left-0 top-0"></span>
                                <a href="#."
                                    id="arrowRight"
                                    class="flex relative z-50 justify-center items-center w-8 h-8 rounded-full border border-solid right-arrow border-gray-1200 shadow-3xl">
                                    <x-icon-swiper-right-arrow class="w-4 h-4" />
                                </a>
                            </div>
                        </div>
                        <div id="default-styled-tab-content">
                            <!-- Tab Loading -->
                            <div id="tabLoading" class="flex items-center justify-center min-h-[200px] bg-white text-gray-800 text-sm font-medium hidden">
                                <x-icon-tab-loading-spinner class="mr-2 w-5 h-5 text-primary-blue" />
                                {{ __('Loading...') }}
                            </div>
                            <!-- Overview Tab Content -->
                            <div class="{{ $activeTab == 'overview' ? '' : 'hidden' }} mt-6"
                                id="styled-Overview"
                                role="tabpanel"
                                aria-labelledby="Overview-tab">
                                <!-- Profile Description Section -->
                                <x-frontend.member.profile.partials.profile-description :user="$user" />

                                <!-- Contact Section -->
                                <x-frontend.member.profile.partials.profile-contact :user="$user" />

                                <!-- Business Hours Section -->
                                <x-frontend.member.profile.partials.profile-business-hours :user="$user" />

                                <!-- Reviews Section -->
                                <x-frontend.member.profile.partials.profile-reviews-summery :user="$user" :reviewsStats="$reviewsStats" />

                                <!-- Credentials Section -->
                                <x-frontend.member.profile.partials.profile-credentials :user="$user" />

                                <!-- FAQs Section -->

                                @if ($user->membershipType->value !== App\Enums\MembershipType::Free->value)
                                    <x-frontend.member.profile.partials.profile-faqs :user="$user" />
                                    <div class="mt-5">
                                        <x-frontend.member.profile.partials.profile-social-media :user="$user" />
                                    </div>
                                @endif

                            </div>

                            <!-- Dynamic Tab Contents -->
                            @foreach ($tabs as $key => $tab)
                                @php
                                    $params = [];
                                    if (in_array('userId', $tab['params'])) {
                                        $params['userId'] = $user->id;
                                    }
                                    if (in_array('reviewsStats', $tab['params'])) {
                                        $params['reviewsStats'] = $reviewsStats;
                                    }
                                @endphp
                                <div class="{{ $activeTab == $key ? '' : 'hidden' }}"
                                    id="styled-{{ $tab['id'] }}"
                                    role="tabpanel"
                                    aria-labelledby="{{ $tab['id'] }}-tab">
                                    <div class="bg-white rounded-lg">
                                        <livewire:dynamic-component :component="$tab['component']"
                                            :userId="$user->id"
                                            :reviewsStats="$reviewsStats"
                                            lazy />
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                <div class="xl:max-w-[447px] max-w-[320px] w-full sticky top-5 md:block hidden">
                    @if ($user->membershipType->value == App\Enums\MembershipType::Free->value)
                        <x-frontend.sidebar.profile-sidebar-free :user="$user" />
                    @else
                        <x-frontend.sidebar.profile-sidebar :user="$user" />
                    @endif
                </div>
            </div>
        </div>
    </section>
@endsection
