@extends('layouts.app')
@php
    use Illuminate\Support\Str;
    // Get featured and gallery images
    $featuredImage = $project->getMedia('featured_image')->first();
    $galleryImages = $project->getMedia('gallery');

    // Create unified collection of all images (featured first, then gallery)
    $allImages = collect();
    if ($featuredImage) {
        $allImages->push($featuredImage);
    }
    $allImages = $allImages->concat($galleryImages);
    // Determine main image and check if we have any images
    $hasImages = $allImages->isNotEmpty();
    $mainImage = $allImages->first();
    $mainImageUrl = $mainImage ? $mainImage->getUrl('large') : '';
    $thumbnailImages = $allImages->skip(1)->take(4);
    $totalImages = $allImages->count();
    $mapIframeUrl = $project->mapIframeUrl();
    $user = $project->user;

    $plainDescription = tiptap_converter()->asHTML($project->description);

    // Limit for preview - approx 300 characters to simulate 3 lines
    $preview = Str::limit($plainDescription, 300);
@endphp
@section('content')
    <section class="pt-8">
        <div class="max-w-[1310px] w-full  mx-auto md:px-4">
            <div class="flex relative flex-col justify-between lg:flex-row">
                <div class="relative px-6 md:px-0">
                    <span class="inline-flex px-2.5 items-center justify-center text-blue-1500 font-medium  text-sm leading-5 tracking-[-0.096px] bg-blue-1400/[0.1] rounded-md h-7 gap-1.5">
                        <x-icon-check-icon />
                        {{ $project->getProjectStatus() }}
                    </span>
                    <h3 class="mt-3 text-2xl font-medium leading-8 text-black-1200">
                        {{ $project->title }}
                    </h3>
                    @if ($project->getProjectTags())
                        <ul class="flex flex-wrap gap-2 items-center mt-3">
                            @foreach ($project->getProjectTags() as $tag)
                                <li><a href="#" class="tags">{{ $tag }}</a></li>
                            @endforeach
                        </ul>
                    @endif
                </div>
                <!-- PROJECT CONTACT  Desktop-->
                <div class="xl:max-w-[321px] lg:max-w-[200px] max-w-full w-full lg:mt-0 mt-4">
                    <div class="md:mb-3">
                        <ul class="flex absolute top-0 right-0 gap-3 justify-center items-center md:static pr-6 md:pr-0">
                            <li>
                                <x-frontend.includes.share-modal-button :user="$user"
                                    url="{{ $project->permalink }}"
                                    type="project"
                                    class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 pr-0.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                    <x-icon-share-icon class="w-4 h-4" />
                                    <span class="hidden md:block">{{ __('Share') }}</span>
                                </x-frontend.includes.share-modal-button>
                            </li>
                            <li>
                                <x-frontend.includes.add-favorite-button module="project"
                                    :modelId="$project->uuid"
                                    :isFavorite="$project->isFavorite()"
                                    class="group md:border-0 border border-solid border-gray-1200 md:gap-3 rounded-full flex items-center justify-center text-sm font-medium tracking-[-0.096px] leading-5 text-mid-gray md:w-auto w-8 h-8 md:h-10 md:px-3.5 hover:bg-gray-1400 hover:text-black-1200 transition-all duration-500 ease-in-out">
                                    <x-icon-save-icon class="w-4 h-4" />
                                    <span class="hidden md:block">{{ __('Save') }}</span>
                                </x-frontend.includes.add-favorite-button>
                            </li>
                        </ul>
                    </div>
                    <div class="grid fixed right-0 bottom-0 left-0 z-10 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:block md:gap-0 md:bg-transparent md:w-auto md:static md:p-0 md:border-0 border-gray-1200 md:relative">
                        @if (!empty($user->profile->phone))
                            <a href="tel:{{ $user->profile->phone }}" class="mb-3 primary-btn">
                                <x-icon-phone-icon class="w-4 h-4" />
                                {{ __('Call') }}
                            </a>
                        @endif
                        @if (!empty($user->email))
                            <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                                <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
                            </x-frontend.includes.contact-modal-button>
                        @endif
                    </div>
                </div>
            </div>
            <!-- PROJECT CONTACT  Mobile-->
            <div class="block px-6 md:hidden md:px-0">
                @if (!empty($user->profile?->phone))
                    <a href="tel:{{ $user->profile?->phone }}" class="mb-3 primary-btn">
                        <x-icon-phone-icon /> {{ __('Calls') }}
                    </a>
                @endif
                @if (!empty($user->email))
                    <x-frontend.includes.contact-modal-button :user="$user" class="secondary-btn">
                        <x-icon-chat-icon-blue class="w-4 h-4" /> {{ __('Message us') }}
                    </x-frontend.includes.contact-modal-button>
                @endif
            </div>

            <!-- Desktop Gallery (hidden on mobile, shows on md+) -->
            @if ($hasImages)
                <div class="hidden grid-cols-2 gap-2.5 mt-8 md:grid" id="project-gallery">
                    <!-- Large image on left -->
                    <div class=" ">
                        @if ($mainImage)
                            <a href="{{ $mainImage->getUrl('large') }}"
                                class="flex justify-center items-center h-full project-gallery-item"
                                data-src="{{ $mainImage->getUrl('large') }}"
                                data-sub-html="{{ $project->title }}">
                                <img src="{{ $mainImage->getUrl('medium') }}"
                                    alt="{{ $project->title }}"
                                    data-src="{{ $mainImage->getUrl('medium') }}"
                                    data-sub-html="{{ $project->title }}"
                                    class="object-cover object-center w-full h-full rounded-xl"
                                    loading="lazy" />
                            </a>
                        @endif
                    </div>

                    <!-- 4 smaller images on right in 2x2 grid -->
                    <div class="grid grid-cols-2 gap-2.5">
                        @for ($i = 1; $i < 5; $i++)
                            @if ($i < $totalImages)
                                @php $image = $allImages->skip($i)->first(); @endphp
                                @if ($i == 4 && $totalImages > 5)
                                    <!-- Last image with "Show all photos" overlay -->
                                    <div class="relative">
                                        <a href="{{ $image->getUrl('thumb') }}"
                                            class="flex justify-center items-center h-full project-gallery-item"
                                            data-src="{{ $image->getUrl('thumb') }}"
                                            data-sub-html="{{ $project->title }}">
                                            <img src="{{ $image->getUrl('thumb') }}"
                                                alt="{{ $project->title }}"
                                                class="object-cover object-center w-full h-full rounded-xl"
                                                loading="lazy" />
                                        </a>
                                        <button onclick="window.openProjectGallery()" class="absolute right-4 bottom-4 flex items-center justify-center text-black font-medium text-sm leading-5 tracking-[-0.096px] gap-2.5 rounded-lg bg-white/[0.9] shadow-4xl h-9 max-w-[153px] w-full hover:bg-white transition-all cursor-pointer">
                                            <x-icon-grid-icon />
                                            {{ __('Show all photos') }}
                                        </button>
                                    </div>
                                @else
                                    <!-- Regular image -->
                                    <div class="">
                                        <a href="{{ $image->getUrl('thumb') }}"
                                            class="flex justify-center items-center h-full project-gallery-item"
                                            data-src="{{ $image->getUrl('thumb') }}"
                                            data-sub-html="{{ $project->title }}">
                                            <img src="{{ $image->getUrl('thumb') }}"
                                                alt="{{ $project->title }}"
                                                class="object-cover object-center w-full h-full rounded-xl"
                                                loading="lazy" />
                                        </a>
                                    </div>
                                @endif
                            @else
                                <!-- Placeholder if less than 5 images -->
                                <div class="h-[152px]"></div>
                                <div class="h-[152px]"></div>
                            @endif
                        @endfor
                    </div>

                    <!-- Hidden images for lightbox (remaining images after first 5) -->
                    @if ($totalImages > 5)
                        <div class="hidden">
                            @foreach ($allImages->skip(5) as $image)
                                <a href="{{ $image->getUrl('thumb') }}"
                                    class="project-gallery-item"
                                    data-src="{{ $image->getUrl('thumb') }}"
                                    data-sub-html="{{ $project->title }}"
                                    >
                                    <img src="{{ $image->getUrl('thumb') }}"
                                        alt="{{ $project->title }}"
                                        class="hidden" 
                                        loading="lazy" />
                                </a>
                            @endforeach
                        </div>
                    @endif
                </div>
                <div class="block mt-8 md:hidden">
                    <div class="swiper gallerySwiper">
                        <div class="swiper-wrapper">
                            @foreach ($allImages as $image)
                                <div class="swiper-slide">
                                    <a href="{{ $image->getUrl('medium') }}"
                                        class="flex justify-center items-center"
                                        data-src="{{ $image->getUrl('medium') }}"
                                        data-sub-html="{{ $project->title }}"
                                        >
                                        <img src="{{ $image->getUrl('medium') }}"
                                            alt="{{ $project->title }}"
                                            class="w-full h-[280px] object-center object-cover"
                                            loading="lazy" />
                                    </a>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination text-xs font-medium leading-4 text-black h-6 rounded-lg bg-gray-1500/[0.24] inline-flex items-center justify-center px-4 bottom-3 right-3 !left-auto !w-auto">
                        </div>
                        <div class="swiper-button-next bg-gray-1500/[0.16] !w-8 !h-8 rounded-full flex items-center justify-center after:hidden">
                            <x-icon-right-arrow-v2 />
                        </div>
                        <div class="swiper-button-prev bg-gray-1500/[0.16] !w-8 !h-8 rounded-full flex items-center justify-center after:hidden">
                            <x-icon-left-arrow-v2 />
                        </div>
                    </div>
                </div>
            @endif
            <!----- PROJECT CONTACT ------>
            <div class="grid grid-cols-1 gap-4 px-6 mt-8 md:grid-cols-4 sm:grid-cols-2 md:px-0">
                @if ($project->getProjectCategory())
                    <div class="flex gap-3.5 items-center p-4 bg-white rounded-2xl border border-solid sm:block sm:gap-0 border-gray-1200">
                        <span class="flex items-center w-6 h-6 sm:mb-4">
                            <x-icon-folder-icon-v2 />
                        </span>
                        <div class="flex-1 w-full">
                            <p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">{{ __('Project Category') }}</p>
                            <h4 class="text-black-1200 font-medium xl:text-base sm:text-sm text-base leading-5 tracking-[-0.176px] mt-1.5">
                                {{ $project->getProjectCategory(1)->pluck('type_name')->first() }}
                            </h4>
                        </div>
                    </div>
                @endif
                @if ($project->address())
                    <div class="flex gap-3.5 items-center p-4 bg-white rounded-2xl border border-solid sm:block sm:gap-0 border-gray-1200">
                        <span class="flex items-center w-6 h-6 sm:mb-4">
                            <x-icon-location-outline-v2 />
                        </span>
                        <div class="flex-1 w-full">
                            <p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">{{ __('Address') }}</p>
                            <h4 class="text-black-1200 font-medium xl:text-base sm:text-sm text-base leading-5 tracking-[-0.176px] mt-1.5">
                                {{ $project->address('short') }}
                            </h4>
                        </div>
                    </div>
                @endif
                @if ($project->publishedAt())
                    <div class="flex gap-3.5 items-center p-4 bg-white rounded-2xl border border-solid sm:block sm:gap-0 border-gray-1200">
                        <span class="flex items-center w-6 h-6 sm:mb-4">
                            <x-icon-calendar-icon3 />
                        </span>
                        <div class="flex-1 w-full">
                            <p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">{{ __('Date') }}</p>
                            <h4 class="text-black-1200 font-medium xl:text-base sm:text-sm text-base leading-5 tracking-[-0.176px] mt-1.5">
                                {{ $project->publishedAt() }}
                            </h4>
                        </div>
                    </div>
                @endif
                @if ($project->getProjectCost())
                    <div class="flex gap-3.5 items-center p-4 bg-white rounded-2xl border border-solid sm:block sm:gap-0 border-gray-1200">
                        <span class="flex items-center w-6 h-6 sm:mb-4">
                            <x-icon-coin-dollar />
                        </span>
                        <div class="flex-1 w-full">
                            <p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">Cost</p>
                            <h4 class="text-black-1200 font-medium xl:text-base sm:text-sm text-base leading-5 tracking-[-0.176px] mt-1.5">
                                {{ $project->getProjectCost() }}
                            </h4>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </section>
    <!----- GALLERY  SEC ------>
    <section class="pt-12 pb-8 sm:pt-8 md:pb-20">
        <div class="max-w-[1310px] w-full mx-auto md:px-4 px-6">
            <div class="flex flex-col gap-0 items-start lg:flex-row lg:gap-8">
                <div class="xl:w-[calc(100%_-_447px)] lg:w-[calc(100%_-_320px)] w-full">
                    <div class="">
                        <div class="sticky top-0 z-10 bg-white">
                            <div class="flex relative items-center py-4 border-b border-gray-1200">
                                <div class="flex overflow-x-auto flex-1 items-center w-full main-tabs">
                                    <span class="flex items-center h-full w-[123px] bg-gradient-to-r from-white/[0] to-white absolute right-0 top-0"></span>
                                    {{-- <a href="#."
                                        id="arrowLeft"
                                        class="flex relative z-50 justify-center items-center w-8 h-8 rounded-full border border-solid left-arrow border-gray-1200 shadow-3xl">
                                        <x-icon-left-arrow-v2 />
                                    </a> --}}
                                    <ul class="flex gap-2 w-max scroll-container" role="list">
                                        @if (!empty($project->description))
                                            <li>
                                                <a href="#styled-Overview"
                                                    class="cursor-pointer whitespace-nowrap inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px] text-mid-gray hover:bg-black-1200 hover:text-white transition-all duration-300"
                                                    onclick="scrollToSection('styled-Overview', event)">
                                                    {{ __('Overview') }}
                                                </a>
                                            </li>
                                        @endif
                                        @if ($project->metrics)
                                            <li>
                                                <a href="#styled-Metrics"
                                                    class="cursor-pointer whitespace-nowrap inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px] text-mid-gray hover:bg-black-1200 hover:text-white transition-all duration-300"
                                                    onclick="scrollToSection('styled-Metrics', event)">
                                                    {{ __('Metrics') }}
                                                </a>
                                            </li>
                                        @endif
                                        @if (!empty($project->introduction) || !empty($project->objective))
                                            <li>
                                                <a href="#styled-Introduction-Objective"
                                                    class="cursor-pointer whitespace-nowrap inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px] text-mid-gray hover:bg-black-1200 hover:text-white transition-all duration-300"
                                                    onclick="scrollToSection('styled-Introduction-Objective', event)">
                                                    {{ __('Introduction & Objective') }}
                                                </a>
                                            </li>
                                        @endif
                                        @if (!empty($project->techniques) || !empty($project->equipments))
                                            <li>
                                                <a href="#styled-Techniques-Equipments"
                                                    class="cursor-pointer whitespace-nowrap inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px] text-mid-gray hover:bg-black-1200 hover:text-white transition-all duration-300"
                                                    onclick="scrollToSection('styled-Techniques-Equipments', event)">
                                                    {{ __('Techniques & Equipments') }}
                                                </a>
                                            </li>
                                        @endif
                                        @if ($project->address)
                                            <li>
                                                <a href="#styled-Locations"
                                                    class="cursor-pointer whitespace-nowrap inline-flex items-center justify-center font-medium text-sm leading-5 tracking-[-0.096px] h-10 rounded-full px-[14.5px] text-mid-gray hover:bg-black-1200 hover:text-white transition-all duration-300"
                                                    onclick="scrollToSection('styled-Locations', event)">
                                                    {{ __('Locations') }}
                                                </a>
                                            </li>
                                        @endif
                                    </ul>
                                </div>
                                {{-- <a href="javascript:void(0)"
                                    id="arrowRight"
                                    class="flex relative z-50 justify-center items-center w-8 h-8 rounded-full border border-solid right-arrow border-gray-1200 shadow-3xl">
                                    <x-icon-right-arrow-v2 />
                                </a> --}}
                            </div>
                        </div>
                        <div id="default-styled-tab-content">
                            @if (!empty($project->description))
                                <div id="styled-Overview"
                                    role="tabpanel"
                                    aria-labelledby="Overview-tab">
                                    <div class="pb-12 mt-6 border-b border-solid article-content border-gray-1200">
                                        <h6>{{ __('Project Overview') }}</h6>

                                        <div x-data="{ expanded: false }" class="">
                                            <!-- Preview: HTML version with line limit -->
                                            <div x-show="!expanded" class="max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray mt-3 line-clamp-3 article-content">
                                                {!! tiptap_converter()->asHTML($project->description) !!}
                                            </div>
                                            <!-- Full: HTML version -->
                                            <div x-show="expanded" class="max-w-[800px] w-full lg:text-base md:text-sm text-base font-normal leading-6 text-mid-gray mt-3 article-content">
                                                {!! tiptap_converter()->asHTML($project->description) !!}
                                            </div>
                                            @if (strlen($project->description) > 200)
                                                <a href="javascript:void(0)"
                                                    @click="expanded = !expanded"
                                                    class="mt-5 readmore-btn">
                                                    <span x-text="expanded ? 'Read less' : 'Read more'"></span>
                                                    <svg :class="{ 'rotate-180': expanded }"
                                                        class="transition-transform duration-300"
                                                        width="11"
                                                        height="7"
                                                        viewBox="0 0 11 7"
                                                        fill="currentColor"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M5.49999 4.54697L9.21249 0.834473L10.273 1.89497L5.49999 6.66797L0.72699 1.89497L1.78749 0.834473L5.49999 4.54697Z" fill="currentColor" />
                                                    </svg>
                                                </a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if (!empty($project->metrics))
                                <div id="styled-Metrics"
                                    role="tabpanel"
                                    aria-labelledby="Metrics-tab"
                                    class="py-12 border-b border-solid border-gray-1200">
                                    <h6>{{ __('Metrics') }}</h6>
                                    <div class="grid grid-cols-2 gap-4 mt-5 sm:grid-cols-3">
                                        @foreach ($project->metrics as $metric)
                                            <div class="p-4 rounded-2xl border border-solid border-gray-1400 bg-gray-1400">

                                                <p class="text-mid-gray font-medium text-sm leading-5 tracking-[-0.096px]">
                                                    {{ $metric['key'] }}
                                                </p>
                                                <h4 class="text-black-1200 font-medium text-base leading-5 tracking-[-0.176px] mt-1.5">
                                                    {{ $metric['value'] }}
                                                </h4>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endif
                            @if (!empty($project->introduction) || !empty($project->objective) || !empty($project->challenges) || !empty($project->solutions))
                                <div id="styled-Introduction-Objective"
                                    role="tabpanel"
                                    aria-labelledby="roduction&Objective-tab"
                                    class="pb-12 mt-6 border-b border-solid border-gray-1200">

                                    @if (!empty($project->introduction) || !empty($project->objective))
                                        <div>
                                            <h6>{{ __('Introduction & Objectice') }}</h6>
                                            @if (!empty($project->introduction))
                                                <div class="mt-5">
                                                    <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                        {{ __('Introduction') }}
                                                    </h4>
                                                    <div class="text-base font-normal leading-6 text-mid-gray article-content">
                                                        {!! $project->introduction !!}
                                                    </div>
                                                </div>
                                            @endif
                                            @if (!empty($project->objective))
                                                <div class="mt-5">
                                                    <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                        {{ __('Objective') }}
                                                    </h4>
                                                    <div class="text-base font-normal leading-6 text-mid-gray article-content">
                                                        {!! $project->objective !!}
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                    @if (!empty($project->challenges) || !empty($project->solutions) || !empty($project->outcomes))
                                        <div class="mt-5">
                                            <h6>{{ __('Challenges & Solutions') }}</h6>
                                            @if (!empty($project->challenges))
                                                <div class="mt-5">
                                                    <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                        {{ __('Challenges') }}
                                                    </h4>
                                                    <div class="text-base font-normal leading-6 text-mid-gray article-content">
                                                        {!! $project->challenges !!}
                                                    </div>
                                                </div>
                                            @endif
                                            @if (!empty($project->solutions))
                                                <div class="mt-5">
                                                    <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                        {{ __('Solutions') }}
                                                    </h4>
                                                    <div class="text-base font-normal leading-6 text-mid-gray article-content">
                                                        {!! $project->solutions !!}
                                                    </div>
                                                </div>
                                            @endif
                                            @if (!empty($project->outcomes))
                                                <div class="mt-5">
                                                    <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                        {{ __('Outcomes') }}
                                                    </h4>
                                                    <div class="text-base font-normal leading-6 text-mid-gray article-content">
                                                        {!! $project->outcomes !!}
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    @endif
                                </div>
                            @endif
                            @if (!empty($project->techniques) || !empty($project->equipments))
                                <div id="styled-Techniques-Equipments"
                                    role="tabpanel"
                                    aria-labelledby="Techniques-Equipments-tab"
                                    class="pb-12 mt-6 border-b border-solid border-gray-1200">
                                    <h6>{{ __('Techniques & Equipments') }}</h6>
                                    @if (!empty($project->techniques))
                                        <div class="mt-5">
                                            <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                {{ __('Techniques') }}
                                            </h4>
                                            <p class="text-base font-normal leading-6 text-mid-gray">
                                                {!! tiptap_converter()->asText($project->techniques) !!}
                                            </p>
                                        </div>
                                    @endif
                                    @if (!empty($project->equipments))
                                        <div class="mt-5">
                                            <h4 class="mb-3 text-base font-medium text-black-1200 leading-6 tracking-[-0.176px]">
                                                {{ __('Equipment') }}
                                            </h4>
                                        </div>
                                        <p class="text-base font-normal leading-6 text-mid-gray">
                                            {!! tiptap_converter()->asText($project->equipments) !!}
                                        </p>
                                    @endif
                                </div>
                            @endif

                            @if ($project->address())
                                <div id="styled-Locations"
                                    role="tabpanel"
                                    aria-labelledby="Locations-styled-tab"
                                    class="pb-12 mt-6 border-b border-solid border-gray-1200">
                                    <h6>{{ __('Project Location') }}</h6>
                                    <div class="mt-3 sm:mt-5">
                                        <p class="mb-5 text-base font-normal leading-6 text-mid-gray">{{ $project->address() }}</p>
                                        @if ($mapIframeUrl)
                                            <iframe width="100%"
                                                height="350"
                                                frameborder="0"
                                                style="border:0"
                                                referrerpolicy="no-referrer-when-downgrade"
                                                src="{{ $mapIframeUrl }}"
                                                class="object-fill rounded-xl">
                                            </iframe>
                                        @endif
                                    </div>
                                    <div class="block mt-12 w-full lg:hidden">
                                        <x-frontend.sidebar.project-author-sidebar :user="$project->user" :reviewsStats="$reviewsStats" />
                                    </div>
                                </div>
                            @endif

                            <x-frontend.project.project-detail.related-projects :project="$project" />

                            <x-frontend.member.profile.partials.profile-social-media :user="$project->user" />
                        </div>
                    </div>
                </div>
                <div class="xl:max-w-[447px] max-w-[320px] w-full sticky top-5 lg:block hidden mt-12">
                    <x-frontend.sidebar.project-author-sidebar :user="$project->user" :reviewsStats="$reviewsStats" />
                </div>
            </div>
        </div>
    </section>
    <div class="grid fixed right-0 bottom-0 left-0 z-50 grid-cols-2 gap-3 p-6 w-full bg-white border-t border-solid bottom-action md:hidden md:p-0 border-gray-1200">
        <a href="{{ route('member.show', $project->author->slug) }}" class="secondary-btn">
            <x-icon-right-top-arrow />
            {{ __('View Profile') }}
        </a>
        <a href="tel:{{ $project->author->phone }}" class="mb-3 primary-btn">
            <x-icon-phone-icon />
            {{ __('Call') }}
        </a>
    </div>
@endsection
