@extends('layouts.app')

@php
    $heading = $page['heading'];
    $description = $page['content'];
    $libraries = 'places,marker';
    $breadcrumbs = ['name' => 'classifieds'];
@endphp

@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries={{ $libraries }}" async defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush

@section('content')
    <section class="lg:py-8 pt-8 pb-0">
        <livewire:frontend.classified.classified-list :page="$page" :breadcrumbs="$breadcrumbs" lazy />
    </section>
@endsection
