@extends('layouts.app')
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@php
    $enabledPageWidgets = $page->pageWidgets()->with('widget')->where('enable', 1)->orderBy('sort_order')->get();
@endphp
@section('content')
    {{-- Page Widgets which are enabled --}}
    @if ($enabledPageWidgets->isNotEmpty())
        @foreach ($enabledPageWidgets as $index => $pageWidget)
            <section class="page-widget-section">
                @if ($pageWidget->widget)
                    @php
                        $component = $pageWidget->widget->component;
                        $type = \App\Filament\Resources\Page\WidgetResource::resolveComponentTypeFromComponent($component);
                    @endphp
                    @if ($type === 'livewire')
                        <livewire:dynamic-component :component="$component" :pageData="$pageWidget->widget->data" :key="'widget-' . $index" />
                    @else
                        <x-dynamic-component :component="$component" :pageData="$pageWidget->widget->data" :key="'widget-' . $index" />
                    @endif
                @endif
            </section>
        @endforeach
    @endif
@endsection
