@extends('layouts.app-home')
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places,marker" async defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush
@php
    $enabledPageWidgets = $page->pageWidgets()->with('widget')->where('enable', 1)->orderBy('sort_order')->get();
@endphp
@section('content')
    {{-- Hero Section --}}
    @if ($page->data['home_template']['banner_version'] == 'v2')
        <x-frontend.widgets.hero-section-v2 :page="$page" />
    @elseif ($page->data['home_template']['banner_version'] == 'v1')
        <x-frontend.widgets.hero-section-v1 :page="$page" />
    @endif
    {{-- Page Widgets which are enabled --}}
    @if ($enabledPageWidgets->isNotEmpty())
        @foreach ($enabledPageWidgets as $index => $pageWidget)
            @if ($pageWidget->widget)
                <section class="page-widget-section">
                    @if ($pageWidget->widget->component_type->value == 'livewire')
                        <livewire:dynamic-component :component="$pageWidget->widget->component"
                            :pageData="$pageWidget->widget->data"
                            :key="'widget-' . $index"
                            {{-- lazy  --}} />
                    @elseif ($pageWidget->widget->component_type->value == 'blade')
                        <x-dynamic-component :component="$pageWidget->widget->component"
                            :pageData="$pageWidget->widget->data"
                            :key="'widget-' . $index" />
                    @endif
                </section>
            @endif
        @endforeach
    @endif
@endsection
