@extends('layouts.app')
@push('seo')
    {!! seo($page ?? null) !!}
@endpush



@php
    $enabledPageWidgets = $page->pageWidgets()->with('widget')->where('enable', 1)->orderBy('sort_order')->get();
@endphp

@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries=places,marker"
        async
        defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush
@section('content')
    {{-- Page Widgets which are enabled --}}
    @if ($enabledPageWidgets->isNotEmpty())
        @foreach ($enabledPageWidgets as $index => $pageWidget)
            <section class="page-widget-section">
                @if ($pageWidget->widget)
                    <x-dynamic-component :component="$pageWidget->widget->component"
                        :pageData="$pageWidget->widget->data"
                        :key="'widget-' . $index"
                         />
                @endif
            </section>
        @endforeach
    @endif
@endsection
