@php
    $defaultView = $page->data['member_list_template']['default_view'] ?? 'list';
    $viewType = !empty(request()->get('view_type')) ? request()->get('view_type') : $defaultView;
    $libraries = 'places,marker';
    $breadcrumbs = ['name' => 'member-list'];
@endphp

@push('plugins')
    {{-- Google Maps JavaScript API with Specified Libraries --}}
    <script src="https://maps.googleapis.com/maps/api/js?key={{ $googleMapsApiKey }}&libraries={{ $libraries }}"
        async
        defer></script>
    {{-- The google-maps.js file is now imported in esp_theme.js via ES modules --}}
@endpush


@if ($viewType == 'map')
    @include('member.map-view', ['page' => $page, 'viewType' => $viewType])
@else
    @include('member.list-view', ['page' => $page, 'viewType' => $viewType])
@endif
