@php
    use Illuminate\Support\Facades\Route;
    use Illuminate\Support\Str;
@endphp
@push('seo')
    {!! seo($page ?? null) !!}
@endpush
@extends('layouts.app')
@section('content')
    <div class="flex justify-center items-center px-6 py-12 min-h-screen bg-gradient-to-br from-blue-50 via-white to-indigo-100">
        <div class="mx-auto max-w-2xl text-center">
            <!-- Main Heading -->
            <div class="mb-12">
                <h1 class="mb-6 text-5xl font-bold text-gray-800 md:text-7xl">
                    Coming Soon
                </h1>
                <div class="mx-auto mb-8 w-24 h-1 bg-gradient-to-r from-blue-500 to-indigo-600 rounded-full"></div>
                <p class="mb-4 text-xl leading-relaxed text-gray-600 md:text-2xl">
                    We're working hard to bring you something amazing.
                </p>
                <p class="text-lg text-gray-500">
                    Our team is putting the finishing touches on our new platform. Stay tuned for updates!
                </p>
            </div>

            <!-- Email Subscription -->
            <div class="mb-16">
                <div class="mx-auto max-w-md">
                    @if (session('success'))
                        <div class="p-4 mb-4 text-sm text-green-800 bg-green-100 rounded-lg border border-green-200">
                            {{ session('success') }}
                        </div>
                    @endif

                    <form action="{{ route('notify-me') }}"
                        method="POST"
                        class="space-y-4">
                        @csrf
                        <div class="flex flex-col gap-4 sm:flex-row">
                            <input type="email"
                                name="email"
                                value="{{ old('email') }}"
                                placeholder="Enter your email"
                                class="flex-1 px-4 py-3 placeholder-gray-500 text-gray-900 bg-white rounded-lg border border-gray-300 transition-all duration-200 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent @error('email') border-red-500 @enderror">
                            <button type="submit" class="px-6 py-3 font-semibold text-white bg-gradient-to-r from-blue-500 to-indigo-600 rounded-lg transition-all duration-200 transform hover:from-blue-600 hover:to-indigo-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 hover:scale-105">
                                Notify Me
                            </button>
                        </div>

                        @error('email')
                            <p class="text-sm text-red-500">{{ $message }}</p>
                        @enderror
                        <div class="flex justify-start">
                            <!-- Captcha Field -->
                            <x-captcha-html-field name="captchaToken"
                                action="notify_me"
                                version="v3"
                                :show-error="true"
                                field-class="flex justify-center"
                                :debug="false" />
                        </div>
                    </form>
                </div>
            </div>

            <!-- Footer -->
            <div class="pt-8 border-t border-gray-200">
                <p class="text-sm text-gray-500">
                    © {{ date('Y') }} {{ config('app.name') }}. {{ Str::title('All rights reserved.') }}
                </p>
            </div>
        </div>
    </div>
@endsection
