import { defineConfig } from 'vite';
import laravel from 'laravel-vite-plugin';
import tailwindcss from '@tailwindcss/vite';
import path from 'path';

export default defineConfig({
    plugins: [
        laravel({
            input: [
                'resources/css/esp_sleek.css',
                'resources/js/esp_sleek.js',
            ],
            buildDirectory: 'themes/ep/esp_sleek/build',
            refresh: true,
            publicDirectory: '../../../public',
        }),
        tailwindcss(),
    ],
    css: {
        postcss: {
            plugins: []
        }
    },
    resolve: {
        alias: {
            '@': path.resolve(__dirname, './resources'),
        },
    },
    base: '/themes/ep/esp_sleek/build/',
});