import { defineConfig } from "vite";
import laravel from "laravel-vite-plugin";

export default defineConfig({
    plugins: [
        laravel({
            input: [
                "resources/css/app.css",
                "resources/sass/app.scss",
                "resources/js/app.js",
                "resources/js/esp_admin/esp_admin.js",
                "resources/css/esp_admin/filament.css",
                "resources/css/dashboard/dashboard.css",
                "resources/js/dashboard/dashboard.js",
                "themes/ep/esp_sleek/resources/js/esp_sleek.js",
                "themes/ep/esp_sleek/resources/js/google-maps.js",
                "resources/js/editor.js",
            ],
            refresh: true,
        }),
    ],
    resolve: {
        alias: {
            'imask': '/node_modules/imask'
        }
    }
});
