import 'package:flutter/material.dart';

import '../theme/app_colors.dart';
import 'buy_button.dart';
import 'favourite_button.dart';

class ButtonsBar extends StatelessWidget {
  final String buyButtonText;
  final Function() onBuyButtonTapped;
  final Function() onFavouriteButtonTapped;

  const ButtonsBar(
      {Key? key,
      required this.buyButtonText,
      required this.onBuyButtonTapped,
      required this.onFavouriteButtonTapped})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      color: AppColors.white,
      child: Padding(
        padding: const EdgeInsets.only(
          left: 24,
          right: 24,
          top: 8,
          bottom: 32,
        ),
        child: Row(
          children: [
            FavouriteButton(
              onTap: onFavouriteButtonTapped,
            ),
            Expanded(
              child: BuyButton(
                buttonText: buyButtonText,
                onTap: onBuyButtonTapped,
              ),
            )
          ],
        ),
      ),
    );
  }
}
