import 'package:flutter/material.dart';

import '../theme/app_colors.dart';

class BuyButton extends StatelessWidget {
  final String buttonText;
  final Function() onTap;

  const BuyButton({
    super.key,
    required this.buttonText,
    required this.onTap,
  });

  @override
  Widget build(BuildContext context) {
    return MaterialButton(
      height: 54,
      color: AppColors.black,
      shape: const RoundedRectangleBorder(
        borderRadius: BorderRadius.all(
          Radius.circular(24),
        ),
      ),
      padding: EdgeInsets.zero,
      onPressed: onTap,
      child: Text(
        buttonText,
        style: TextStyle(
          color: AppColors.white,
          fontSize: 20,
          fontWeight: FontWeight.w500,
        ),
      ),
    );
  }
}
