import 'package:flutter/material.dart';

import '../theme/app_colors.dart';

class CurvedCornerContainer extends StatelessWidget {
  final Widget? child;
  final double minHeight;
  final double maxHeight;

  const CurvedCornerContainer({
    super.key,
    this.child,
    this.minHeight = 260,
    this.maxHeight = 380,
  });

  @override
  Widget build(BuildContext context) {
    return ClipPath(
      clipper: FancyClipPath(),
      child: Container(
        constraints: BoxConstraints(
          minHeight: minHeight,
          maxHeight: maxHeight,
        ),
        color: AppColors.white,
        child: child,
      ),
    );
  }
}

class FancyClipPath extends CustomClipper<Path> {
  @override
  Path getClip(Size size) {
    const radius = 48.0;
    Path path = Path();
    path.moveTo(0, radius * 2);
    path.arcToPoint(
      const Offset(radius, radius),
      radius: const Radius.circular(
        radius,
      ),
    );
    path.lineTo(size.width - radius, radius);
    path.arcToPoint(
      Offset(size.width, 0),
      radius: const Radius.circular(radius),
      clockwise: false,
    );
    path.lineTo(size.width, size.height);
    path.lineTo(0, size.height);
    path.close();
    return path;
  }

  @override
  bool shouldReclip(covariant CustomClipper<Path> oldClipper) {
    return false;
  }
}
