import 'package:flutter/material.dart';

import '../theme/app_colors.dart';

class DescriptionContent extends StatelessWidget {
  final String productTitle;
  final String brand;
  final String description;

  const DescriptionContent({
    super.key,
    required this.productTitle,
    required this.brand,
    required this.description,
  });

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.only(
        left: 24,
        right: 24,
        bottom: 14,
        top: 8,
      ),
      child: Column(
        mainAxisSize: MainAxisSize.min,
        mainAxisAlignment: MainAxisAlignment.end,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            productTitle,
            style: TextStyle(
              fontSize: 30,
              color: AppColors.black,
              fontWeight: FontWeight.w600,
            ),
          ),
          Text(
            brand,
            style: TextStyle(
              fontSize: 14,
              color: AppColors.black,
              fontWeight: FontWeight.w500,
            ),
          ),
          Padding(
            padding: const EdgeInsets.only(top: 28.0),
            child: Text(
              description,
              style: TextStyle(
                  fontSize: 14,
                  color: AppColors.black,
                  fontWeight: FontWeight.w400),
            ),
          )
        ],
      ),
    );
  }
}
