import 'package:flutter/material.dart';

class RoundedCornerImage extends StatelessWidget {
  final Offset imageOffset;
  final String asset;
  final double scale;

  const RoundedCornerImage({
    super.key,
    required this.asset,
    this.imageOffset = Offset.zero,
    this.scale = 1,
  });

  @override
  Widget build(BuildContext context) {
    return ClipRRect(
      borderRadius: const BorderRadius.all(
        Radius.circular(40),
      ),
      child: Transform.translate(
        offset: imageOffset,
        child: Transform.scale(
          scale: scale,
          child: Image.asset(
            asset,
            alignment: Alignment.topCenter,
          ),
        ),
      ),
    );
  }
}
