import 'theme/app_colors.dart';

import 'package:flutter/material.dart';

import 'elements/buttons_bar.dart';
import 'elements/curved_corner_container.dart';
import 'elements/description_content.dart';
import 'elements/rounded_corner_image.dart';

class MainScreen extends StatelessWidget {
  const MainScreen({super.key});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.white,
      bottomNavigationBar: ButtonsBar(
        buyButtonText: 'Buy for \$145.00',
        onFavouriteButtonTapped: () => {},
        onBuyButtonTapped: () => {},
      ),
      body: const Padding(
        padding: EdgeInsets.all(6),
        child: Stack(
          children: [
            Positioned.fill(
              child: RoundedCornerImage(
                asset: 'assets/images/spring-dress.jpg',
                scale: 2.2,
                imageOffset: Offset(0, 340),
              ),
            ),
            Align(
              alignment: Alignment.bottomCenter,
              child: CurvedCornerContainer(
                child: DescriptionContent(
                  productTitle: 'Plain Sweatshirt',
                  brand: 'Tamara B.',
                  description:
                      'Our products are made using sustainable fibers and processes that reduce environmental impact.',
                ),
              ),
            ),
          ],
        ),
      ),
    );
  }
}
