//
//  DataManager.swift
//  BooksShelfStarter
//
//  Created by Giugliano Antonella on 04/03/25.
//
import Foundation
import SwiftData

@MainActor
class DataManager {
    
    static func collectAllBooks() async throws -> [Book] {
        let modelContext = DataModel.shared.modelContainer.mainContext
        let entries = try modelContext.fetch(FetchDescriptor<Book>())
        
        return entries
    }
    
    static func collectBooks(for identifiers: [UUID]) async throws -> [Book] {
        let modelContext = DataModel.shared.modelContainer.mainContext
        
        let books = try modelContext.fetch(FetchDescriptor<Book>(predicate: #Predicate {
            identifiers.contains($0.id)
        }))
        
        return books
    }
    
    static func collectBooks(matching string: String) async throws -> [Book] {
        let allBooks = try await collectAllBooks()
        
        let filteredBooks = allBooks.filter { book in
            let titleMatches = book.title.localizedCaseInsensitiveContains(string)
            let authorMatches = book.author?.localizedCaseInsensitiveContains(string) ?? false
            return titleMatches || authorMatches
        }
        
        return filteredBooks
    }
    
    static func createNewBook(book: Book) async throws {
        let modelContext = ModelContext(DataModel.shared.modelContainer)
        
        modelContext.insert(book)
        try modelContext.save()
        BookShelfShortcutsProvider.updateAppShortcutParameters()
    }
    
    static func deleteBook(book: Book) async throws {
        let modelContext = DataModel.shared.modelContainer.mainContext
        
        modelContext.delete(book)
        try? modelContext.save()
        BookShelfShortcutsProvider.updateAppShortcutParameters()
    }
}
