//
//  BooksShelfStarterApp.swift
//  BooksShelfStarter
//
//  Created by Giugliano Antonella on 04/03/25.
//

import SwiftUI
import AppIntents

@main
struct BooksShelfStarterApp: App {
    
    let modelContainer = DataModel.shared.modelContainer
    let navigationManager: NavigationManager

    init() {
        let navigationManager = NavigationManager()
        AppDependencyManager.shared.add(dependency: navigationManager)
        self.navigationManager = navigationManager
    }
    
    var body: some Scene {
        WindowGroup {
            BooksListView()
        }
        .environment(navigationManager)
        .modelContainer(modelContainer)
    }
}
