//
//  OpenBookIntent.swift
//  BooksShelfStarter
//
//  Created by Giugliano Antonella on 07/03/25.
//
import AppIntents

@AssistantIntent(schema: .books.openBook)
struct OpenBookIntent: OpenIntent {
    var target: BookEntity
    
    @Dependency
    private var navigationManager: NavigationManager
    
    @MainActor
    func perform() async throws -> some IntentResult {
        let id = target.id
        let books = try await DataManager.collectBooks(for: [id])
        guard let book = books.first else {
            throw fatalError("Entity Not Found")
        }
        navigationManager.openBook(book: book)
        return .result()
    }
}
