//
//  Book.swift
//  BooksShelfStarter
//
//  Created by Giugliano Antonella on 04/03/25.
//  Updated by Tiago Pereira on 07/03/25
//

import SwiftUI
import SwiftData


@Model
final class Book {
    @Attribute(.unique) var id: UUID = UUID()
    
    var title: String
    var author: String?
    var genre: Genre?
    var contentType: BookContentType?
    var read: Bool = false
    var url: URL? = nil
    
    
    init(title: String, author: String? = nil, genre: Genre? = nil, contentType: BookContentType? = nil, read: Bool = false, url: URL? = nil) {
        self.title = title
        self.author = author ?? "No author"
        self.genre = genre ?? .unspecified
        self.contentType = contentType ?? .physicalBook
        self.read = read
        self.url = url //?? URL(string: "https://www.createwithswift.com/")!
    }
}

enum Genre: String, CaseIterable, Codable, Identifiable {
    case fantasy = "Fantasy"
    case scienceFiction = "Science Fiction"
    case romance = "Romance"
    case mystery = "Mystery"
    case horror = "Horror"
    case selfHelp = "Self Help"
    case biography = "Biography"
    case history = "History"
    case cookbook = "Cookbook"
    
    case unspecified = "Unspecified"
    
    var id: Self { self }
}

enum BookContentType: String, Codable, CaseIterable, Identifiable{
    case physicalBook = "Physical Book"
    case eBook = "eBook"
    
    var id: Self { self }
}
