//
//  BooksShelfControlActionStarterApp.swift
//  BooksShelfControlActionStarter
//
//  Created by Giugliano Antonella on 09/05/25.
//

import SwiftUI
import AppIntents

@main
struct BooksShelfControlActionStarterApp: App {
    let modelContainer = DataModel.shared.modelContainer
    let navigationManager: NavigationManager

    init() {
        let navigationManager = NavigationManager()
        AppDependencyManager.shared.add(dependency: navigationManager)
        self.navigationManager = navigationManager
    }
    
    var body: some Scene {
        WindowGroup {
            BooksListView()
        }
        .environment(navigationManager)
        .modelContainer(modelContainer)
    }
}
