//
//  GoToAddBookIntent.swift
//  BooksShelfControlActionStarter
//
//  Created by Giugliano Antonella on 09/05/25.
//

import AppIntents

struct GoToAddBookIntent: AppIntent {
    static var title: LocalizedStringResource = "Add a Book to your Shelf"

    @Dependency
    var navigationManager: NavigationManager
    
    static var openAppWhenRun: Bool = true
    
    @MainActor
    func perform() async throws -> some IntentResult {
        navigationManager.openAddBook()
        return .result()
    }
}
